/*
 * Copyright (C) 2010 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by {@link BuildMetadataProtoFromXml}.
 * Please don't modify it directly.
 */

package com.google.i18n.phonenumbers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountryCodeToRegionCodeMapForAlternate {
  // A mapping from a country code to the region codes which denote the
  // country/region represented by that country code. In the case of multiple
  // countries sharing a calling code, such as the NANPA countries, the one
  // indicated with "isMainCountryForCode" in the metadata should be first.
  static Map<Integer, List<String>> getCountryCodeToRegionCodeMap() {
    // The capacity is set to 6 as there are 5 different country codes,
    // and this offers a load factor of roughly 0.75.
    Map<Integer, List<String>> countryCodeToRegionCodeMap =
        new HashMap<Integer, List<String>>(6);

    ArrayList<String> listWithRegionCode;

    listWithRegionCode = new ArrayList<String>(1);
    listWithRegionCode.add("");
    countryCodeToRegionCodeMap.put(44, listWithRegionCode);

    listWithRegionCode = new ArrayList<String>(1);
    listWithRegionCode.add("");
    countryCodeToRegionCodeMap.put(49, listWithRegionCode);

    listWithRegionCode = new ArrayList<String>(1);
    listWithRegionCode.add("");
    countryCodeToRegionCodeMap.put(55, listWithRegionCode);

    listWithRegionCode = new ArrayList<String>(1);
    listWithRegionCode.add("");
    countryCodeToRegionCodeMap.put(61, listWithRegionCode);

    listWithRegionCode = new ArrayList<String>(1);
    listWithRegionCode.add("");
    countryCodeToRegionCodeMap.put(81, listWithRegionCode);

    return countryCodeToRegionCodeMap;
  }
}
