/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.tools.BuildMetadataFromXml;
import com.google.i18n.phonenumbers.tools.Command;
import com.google.i18n.phonenumbers.tools.CopyrightNotice;
import com.google.i18n.phonenumbers.tools.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class BuildMetadataCppFromXml
extends Command {
    private String inputFilePath;
    private String outputDir;
    private String baseFilename;
    private boolean liteMetadata;
    private ByteArrayOutputStream binaryStream = new ByteArrayOutputStream();
    private FileOutputStream headerFileOutputStream;
    private FileOutputStream implFileOutputStream;
    private static final Set<String> METADATA_TYPES = new HashSet<String>(Arrays.asList("metadata", "test_metadata", "lite_metadata"));

    void setBinaryStream(ByteArrayOutputStream stream) {
        this.binaryStream = stream;
    }

    public String getCommandName() {
        return "BuildMetadataCppFromXml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        if (!this.parseCommandLine()) {
            return false;
        }
        try {
            this.generateBinaryFromXml();
            this.openFiles();
            this.emitHeader();
            this.emitImplementation();
        }
        catch (Exception e) {
            boolean bl;
            try {
                System.err.println(e.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeFiles(this.headerFileOutputStream, this.implFileOutputStream);
                throw throwable;
            }
            FileUtils.closeFiles(this.headerFileOutputStream, this.implFileOutputStream);
            return bl;
        }
        FileUtils.closeFiles(this.headerFileOutputStream, this.implFileOutputStream);
        return true;
    }

    private void generateBinaryFromXml() throws Exception {
        Phonemetadata.PhoneMetadataCollection collection = BuildMetadataFromXml.buildPhoneMetadataCollection(this.inputFilePath, this.liteMetadata);
        collection.writeTo(this.binaryStream);
    }

    private void openFiles() throws IOException {
        this.headerFileOutputStream = new FileOutputStream(String.format("%s/metadata.h", this.outputDir));
        this.implFileOutputStream = new FileOutputStream(String.format("%s/%s.cc", this.outputDir, this.baseFilename));
    }

    private void emitNamespacesBeginning(PrintWriter pw) {
        pw.println("namespace i18n {");
        pw.println("namespace phonenumbers {");
    }

    private void emitNamespacesEnd(PrintWriter pw) {
        pw.println("}  // namespace phonenumbers");
        pw.println("}  // namespace i18n");
    }

    private void emitHeader() {
        PrintWriter pw = new PrintWriter(this.headerFileOutputStream);
        pw.write(CopyrightNotice.TEXT);
        String guardName = "I18N_PHONENUMBERS_METADATA_H_";
        pw.println("#ifndef I18N_PHONENUMBERS_METADATA_H_");
        pw.println("#define I18N_PHONENUMBERS_METADATA_H_");
        pw.println();
        this.emitNamespacesBeginning(pw);
        pw.println();
        pw.println("int metadata_size();");
        pw.println("const void* metadata_get();");
        pw.println();
        this.emitNamespacesEnd(pw);
        pw.println();
        pw.println("#endif  // I18N_PHONENUMBERS_METADATA_H_");
        pw.close();
    }

    private void emitImplementation() throws IOException {
        PrintWriter pw = new PrintWriter(this.implFileOutputStream);
        pw.write(CopyrightNotice.TEXT);
        pw.println("#include \"phonenumbers/metadata.h\"");
        pw.println();
        this.emitNamespacesBeginning(pw);
        pw.println();
        pw.println("namespace {");
        pw.print("static const unsigned char data[] = {");
        this.emitStaticArrayCode(pw);
        pw.println("};");
        pw.println("}  // namespace");
        pw.println();
        pw.println("int metadata_size() {");
        pw.println("  return sizeof(data) / sizeof(data[0]);");
        pw.println("}");
        pw.println();
        pw.println("const void* metadata_get() {");
        pw.println("  return data;");
        pw.println("}");
        pw.println();
        this.emitNamespacesEnd(pw);
        pw.close();
    }

    void emitStaticArrayCode(PrintWriter pw) throws IOException {
        byte[] buf = this.binaryStream.toByteArray();
        pw.print("\n  ");
        for (int i = 0; i < buf.length; ++i) {
            String format = "0x%02X";
            format = i == buf.length - 1 ? format + "\n" : ((i + 1) % 13 == 0 ? format + ",\n  " : format + ", ");
            pw.printf(format, buf[i]);
        }
        pw.flush();
        this.binaryStream.flush();
        this.binaryStream.close();
    }

    private boolean parseCommandLine() {
        String[] args = this.getArgs();
        if (args.length != 4 || !METADATA_TYPES.contains(args[3])) {
            System.err.println(String.format("Usage: %s <inputXmlFile> <outputDir> ( metadata | test_metadata | lite_metadata )", this.getCommandName()));
            return false;
        }
        this.inputFilePath = args[1];
        this.outputDir = args[2];
        this.baseFilename = args[3];
        this.liteMetadata = this.baseFilename.equals("lite_metadata");
        return true;
    }
}

