/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class FileUtils {
    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void closeFiles(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            FileUtils.close(closeable);
        }
    }

    public static boolean isGenerationRequired(File inputFile, File outputDir) {
        if (!outputDir.exists()) {
            return true;
        }
        return FileUtils.getLastModificationTime(inputFile) > FileUtils.getLastModificationTime(outputDir);
    }

    private static long getLastModificationTime(File file) {
        if (!file.isDirectory()) {
            return file.lastModified();
        }
        long maxModificationTime = 0L;
        for (File child : file.listFiles()) {
            long modificationTime = FileUtils.getLastModificationTime(child);
            if (modificationTime <= maxModificationTime) continue;
            maxModificationTime = modificationTime;
        }
        return maxModificationTime;
    }
}

