/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaCodeMap
implements Externalizable {
    private int numOfEntries = 0;
    private TreeSet<Integer> possibleLengths = new TreeSet();
    private int[] phoneNumberPrefixes;
    private String[] descriptions;
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();

    public void readAreaCodeMap(SortedMap<Integer, String> sortedAreaCodeMap) {
        this.numOfEntries = sortedAreaCodeMap.size();
        this.phoneNumberPrefixes = new int[this.numOfEntries];
        this.descriptions = new String[this.numOfEntries];
        int index = 0;
        for (int prefix : sortedAreaCodeMap.keySet()) {
            this.phoneNumberPrefixes[index++] = prefix;
            this.possibleLengths.add((int)Math.log10(prefix) + 1);
        }
        sortedAreaCodeMap.values().toArray(this.descriptions);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.numOfEntries = objectInput.readInt();
        if (this.phoneNumberPrefixes == null || this.phoneNumberPrefixes.length < this.numOfEntries) {
            this.phoneNumberPrefixes = new int[this.numOfEntries];
        }
        if (this.descriptions == null || this.descriptions.length < this.numOfEntries) {
            this.descriptions = new String[this.numOfEntries];
        }
        for (int i = 0; i < this.numOfEntries; ++i) {
            this.phoneNumberPrefixes[i] = objectInput.readInt();
            this.descriptions[i] = objectInput.readUTF();
        }
        int sizeOfLengths = objectInput.readInt();
        this.possibleLengths.clear();
        for (int i = 0; i < sizeOfLengths; ++i) {
            this.possibleLengths.add(objectInput.readInt());
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.numOfEntries);
        for (int i = 0; i < this.numOfEntries; ++i) {
            objectOutput.writeInt(this.phoneNumberPrefixes[i]);
            objectOutput.writeUTF(this.descriptions[i]);
        }
        int sizeOfLengths = this.possibleLengths.size();
        objectOutput.writeInt(sizeOfLengths);
        for (Integer length : this.possibleLengths) {
            objectOutput.writeInt(length);
        }
    }

    String lookup(Phonenumber.PhoneNumber number) {
        if (this.numOfEntries == 0) {
            return "";
        }
        long phonePrefix = Long.parseLong(number.getCountryCode() + this.phoneUtil.getNationalSignificantNumber(number));
        int currentIndex = this.numOfEntries - 1;
        SortedSet<Integer> currentSetOfLengths = this.possibleLengths;
        while (currentSetOfLengths.size() > 0) {
            Integer possibleLength = (Integer)currentSetOfLengths.last();
            String phonePrefixStr = String.valueOf(phonePrefix);
            if (phonePrefixStr.length() > possibleLength) {
                phonePrefix = Long.parseLong(phonePrefixStr.substring(0, possibleLength));
            }
            if ((currentIndex = this.binarySearch(0, currentIndex, phonePrefix)) < 0) {
                return "";
            }
            if (phonePrefix == (long)this.phoneNumberPrefixes[currentIndex]) {
                return this.descriptions[currentIndex];
            }
            currentSetOfLengths = this.possibleLengths.headSet(possibleLength);
        }
        return "";
    }

    private int binarySearch(int start, int end, long value) {
        int current = 0;
        while (start <= end) {
            current = (start + end) / 2;
            if ((long)this.phoneNumberPrefixes[current] == value) {
                return current;
            }
            if ((long)this.phoneNumberPrefixes[current] > value) {
                end = --current;
                continue;
            }
            start = current + 1;
        }
        return current;
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < this.numOfEntries; ++i) {
            output.append(this.phoneNumberPrefixes[i]);
            output.append("|");
            output.append(this.descriptions[i]);
            output.append("\n");
        }
        return output.toString();
    }
}

