/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.geocoding.AreaCodeMap;
import com.google.i18n.phonenumbers.geocoding.MappingFileProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhoneNumberOfflineGeocoder {
    private static PhoneNumberOfflineGeocoder instance = null;
    private static final String MAPPING_DATA_DIRECTORY = "/com/google/i18n/phonenumbers/geocoding/data/";
    private static final Logger LOGGER = Logger.getLogger(PhoneNumberOfflineGeocoder.class.getName());
    private final PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private final String phonePrefixDataDirectory;
    private MappingFileProvider mappingFileProvider = new MappingFileProvider();
    private Map<String, AreaCodeMap> availablePhonePrefixMaps = new HashMap<String, AreaCodeMap>();

    PhoneNumberOfflineGeocoder(String phonePrefixDataDirectory) {
        this.phonePrefixDataDirectory = phonePrefixDataDirectory;
        this.loadMappingFileProvider();
    }

    private void loadMappingFileProvider() {
        InputStream source = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + "config");
        try {
            ObjectInputStream in = new ObjectInputStream(source);
            this.mappingFileProvider.readExternal(in);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.toString());
        }
    }

    private AreaCodeMap getPhonePrefixDescriptions(int countryCallingCode, String language, String script, String region) {
        String fileName = this.mappingFileProvider.getFileName(countryCallingCode, language, script, region);
        if (fileName.length() == 0) {
            return null;
        }
        if (!this.availablePhonePrefixMaps.containsKey(fileName)) {
            this.loadAreaCodeMapFromFile(fileName);
        }
        return this.availablePhonePrefixMaps.get(fileName);
    }

    private void loadAreaCodeMapFromFile(String fileName) {
        InputStream source = PhoneNumberOfflineGeocoder.class.getResourceAsStream(this.phonePrefixDataDirectory + fileName);
        try {
            ObjectInputStream in = new ObjectInputStream(source);
            AreaCodeMap map = new AreaCodeMap();
            map.readExternal(in);
            this.availablePhonePrefixMaps.put(fileName, map);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.toString());
        }
    }

    public static synchronized PhoneNumberOfflineGeocoder getInstance() {
        if (instance == null) {
            instance = new PhoneNumberOfflineGeocoder(MAPPING_DATA_DIRECTORY);
        }
        return instance;
    }

    public void loadDataFile(Locale locale, int countryCallingCode) {
        instance.getPhonePrefixDescriptions(countryCallingCode, locale.getLanguage(), "", locale.getCountry());
    }

    private String getCountryNameForNumber(Phonenumber.PhoneNumber number, Locale language) {
        String regionCode = this.phoneUtil.getRegionCodeForNumber(number);
        return regionCode == null || regionCode.equals("ZZ") ? "" : new Locale("", regionCode).getDisplayCountry(language);
    }

    public String getDescriptionForNumber(Phonenumber.PhoneNumber number, Locale languageCode) {
        String areaDescription = this.getAreaDescriptionForNumber(number, languageCode.getLanguage(), "", languageCode.getCountry());
        return areaDescription.length() > 0 ? areaDescription : this.getCountryNameForNumber(number, languageCode);
    }

    private String getAreaDescriptionForNumber(Phonenumber.PhoneNumber number, String lang, String script, String region) {
        AreaCodeMap phonePrefixDescriptions = this.getPhonePrefixDescriptions(number.getCountryCode(), lang, script, region);
        return phonePrefixDescriptions != null ? phonePrefixDescriptions.lookup(number) : "";
    }
}

