/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import com.google.i18n.phonenumbers.Phonemetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMetadataFromXml {
    private static final Logger LOGGER = Logger.getLogger(BuildMetadataFromXml.class.getName());
    private static Boolean liteBuild;

    public static Phonemetadata.PhoneMetadataCollection buildPhoneMetadataCollection(String inputXmlFile, boolean liteBuild) throws Exception {
        BuildMetadataFromXml.liteBuild = liteBuild;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        File xmlFile = new File(inputXmlFile);
        Document document = builder.parse(xmlFile);
        document.getDocumentElement().normalize();
        Element rootElement = document.getDocumentElement();
        NodeList territory = rootElement.getElementsByTagName("territory");
        Phonemetadata.PhoneMetadataCollection.Builder metadataCollection = Phonemetadata.PhoneMetadataCollection.newBuilder();
        int numOfTerritories = territory.getLength();
        for (int i = 0; i < numOfTerritories; ++i) {
            Element territoryElement = (Element)territory.item(i);
            String regionCode = territoryElement.getAttribute("id");
            Phonemetadata.PhoneMetadata metadata = BuildMetadataFromXml.loadCountryMetadata(regionCode, territoryElement);
            metadataCollection.addMetadata(metadata);
        }
        return metadataCollection.build();
    }

    public static Map<Integer, List<String>> buildCountryCodeToRegionCodeMap(Phonemetadata.PhoneMetadataCollection metadataCollection) {
        TreeMap<Integer, List<String>> countryCodeToRegionCodeMap = new TreeMap<Integer, List<String>>();
        for (Phonemetadata.PhoneMetadata metadata : metadataCollection.getMetadataList()) {
            String regionCode = metadata.getId();
            int countryCode = metadata.getCountryCode();
            if (countryCodeToRegionCodeMap.containsKey(countryCode)) {
                if (metadata.getMainCountryForCode()) {
                    ((List)countryCodeToRegionCodeMap.get(countryCode)).add(0, regionCode);
                    continue;
                }
                ((List)countryCodeToRegionCodeMap.get(countryCode)).add(regionCode);
                continue;
            }
            ArrayList<String> listWithRegionCode = new ArrayList<String>(1);
            listWithRegionCode.add(regionCode);
            countryCodeToRegionCodeMap.put(countryCode, listWithRegionCode);
        }
        return countryCodeToRegionCodeMap;
    }

    private static String validateRE(String regex) {
        return BuildMetadataFromXml.validateRE(regex, false);
    }

    private static String validateRE(String regex, boolean removeWhitespace) {
        if (removeWhitespace) {
            regex = regex.replaceAll("\\s", "");
        }
        Pattern.compile(regex);
        return regex;
    }

    private static Phonemetadata.PhoneMetadata loadCountryMetadata(String regionCode, Element element) {
        Phonemetadata.PhoneMetadata.Builder metadata = Phonemetadata.PhoneMetadata.newBuilder();
        metadata.setId(regionCode);
        metadata.setCountryCode(Integer.parseInt(element.getAttribute("countryCode")));
        if (element.hasAttribute("leadingDigits")) {
            metadata.setLeadingDigits(BuildMetadataFromXml.validateRE(element.getAttribute("leadingDigits")));
        }
        metadata.setInternationalPrefix(BuildMetadataFromXml.validateRE(element.getAttribute("internationalPrefix")));
        if (element.hasAttribute("preferredInternationalPrefix")) {
            String preferredInternationalPrefix = element.getAttribute("preferredInternationalPrefix");
            metadata.setPreferredInternationalPrefix(preferredInternationalPrefix);
        }
        if (element.hasAttribute("nationalPrefixForParsing")) {
            metadata.setNationalPrefixForParsing(BuildMetadataFromXml.validateRE(element.getAttribute("nationalPrefixForParsing")));
            if (element.hasAttribute("nationalPrefixTransformRule")) {
                metadata.setNationalPrefixTransformRule(BuildMetadataFromXml.validateRE(element.getAttribute("nationalPrefixTransformRule")));
            }
        }
        String nationalPrefix = "";
        String nationalPrefixFormattingRule = "";
        if (element.hasAttribute("nationalPrefix")) {
            nationalPrefix = element.getAttribute("nationalPrefix");
            metadata.setNationalPrefix(nationalPrefix);
            nationalPrefixFormattingRule = BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(element, nationalPrefix);
            if (!metadata.hasNationalPrefixForParsing()) {
                metadata.setNationalPrefixForParsing(nationalPrefix);
            }
        }
        String carrierCodeFormattingRule = "";
        if (element.hasAttribute("carrierCodeFormattingRule")) {
            carrierCodeFormattingRule = BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(element, nationalPrefix));
        }
        if (element.hasAttribute("preferredExtnPrefix")) {
            metadata.setPreferredExtnPrefix(element.getAttribute("preferredExtnPrefix"));
        }
        if (element.hasAttribute("mainCountryForCode")) {
            metadata.setMainCountryForCode(true);
        }
        if (element.hasAttribute("leadingZeroPossible")) {
            metadata.setLeadingZeroPossible(true);
        }
        NodeList numberFormatElements = element.getElementsByTagName("numberFormat");
        boolean hasExplicitIntlFormatDefined = false;
        int numOfFormatElements = numberFormatElements.getLength();
        if (numOfFormatElements > 0) {
            for (int i = 0; i < numOfFormatElements; ++i) {
                Element numberFormatElement = (Element)numberFormatElements.item(i);
                Phonemetadata.NumberFormat.Builder format = Phonemetadata.NumberFormat.newBuilder();
                if (numberFormatElement.hasAttribute("nationalPrefixFormattingRule")) {
                    format.setNationalPrefixFormattingRule(BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(numberFormatElement, nationalPrefix));
                } else {
                    format.setNationalPrefixFormattingRule(nationalPrefixFormattingRule);
                }
                if (numberFormatElement.hasAttribute("carrierCodeFormattingRule")) {
                    format.setDomesticCarrierCodeFormattingRule(BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(numberFormatElement, nationalPrefix)));
                } else {
                    format.setDomesticCarrierCodeFormattingRule(carrierCodeFormattingRule);
                }
                BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, format);
                format.setPattern(BuildMetadataFromXml.validateRE(numberFormatElement.getAttribute("pattern")));
                NodeList formatPattern = numberFormatElement.getElementsByTagName("format");
                if (formatPattern.getLength() != 1) {
                    LOGGER.log(Level.SEVERE, "Only one format pattern for a numberFormat element should be defined.");
                    throw new RuntimeException("Invalid number of format patterns for country: " + regionCode);
                }
                String nationalFormat = formatPattern.item(0).getFirstChild().getNodeValue();
                format.setFormat(nationalFormat);
                metadata.addNumberFormat(format);
                Phonemetadata.NumberFormat.Builder intlFormat = Phonemetadata.NumberFormat.newBuilder();
                BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, intlFormat);
                intlFormat.setPattern(numberFormatElement.getAttribute("pattern"));
                NodeList intlFormatPattern = numberFormatElement.getElementsByTagName("intlFormat");
                if (intlFormatPattern.getLength() > 1) {
                    LOGGER.log(Level.SEVERE, "A maximum of one intlFormat pattern for a numberFormat element should be defined.");
                    throw new RuntimeException("Invalid number of intlFormat patterns for country: " + regionCode);
                }
                if (intlFormatPattern.getLength() == 0) {
                    intlFormat.setFormat(nationalFormat);
                } else {
                    String intlFormatPatternValue = intlFormatPattern.item(0).getFirstChild().getNodeValue();
                    if (!intlFormatPatternValue.equals("NA")) {
                        intlFormat.setFormat(intlFormatPatternValue);
                    }
                    hasExplicitIntlFormatDefined = true;
                }
                if (!intlFormat.hasFormat()) continue;
                metadata.addIntlNumberFormat(intlFormat);
            }
            if (!hasExplicitIntlFormatDefined) {
                metadata.clearIntlNumberFormat();
            }
        }
        Phonemetadata.PhoneNumberDesc.Builder generalDesc = Phonemetadata.PhoneNumberDesc.newBuilder();
        generalDesc = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "generalDesc");
        metadata.setGeneralDesc(generalDesc);
        metadata.setFixedLine(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "fixedLine"));
        metadata.setMobile(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "mobile"));
        metadata.setTollFree(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "tollFree"));
        metadata.setPremiumRate(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "premiumRate"));
        metadata.setSharedCost(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "sharedCost"));
        metadata.setVoip(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "voip"));
        metadata.setPersonalNumber(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "personalNumber"));
        metadata.setPager(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "pager"));
        metadata.setUan(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "uan"));
        metadata.setNoInternationalDialling(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, "noInternationalDialling"));
        if (metadata.getMobile().getNationalNumberPattern().equals(metadata.getFixedLine().getNationalNumberPattern())) {
            metadata.setSameMobileAndFixedLinePattern(true);
        }
        return metadata.build();
    }

    private static void setLeadingDigitsPatterns(Element numberFormatElement, Phonemetadata.NumberFormat.Builder format) {
        NodeList leadingDigitsPatternNodes = numberFormatElement.getElementsByTagName("leadingDigits");
        int numOfLeadingDigitsPatterns = leadingDigitsPatternNodes.getLength();
        if (numOfLeadingDigitsPatterns > 0) {
            for (int i = 0; i < numOfLeadingDigitsPatterns; ++i) {
                format.addLeadingDigitsPattern(BuildMetadataFromXml.validateRE(leadingDigitsPatternNodes.item(i).getFirstChild().getNodeValue(), true));
            }
        }
    }

    private static String getNationalPrefixFormattingRuleFromElement(Element element, String nationalPrefix) {
        String nationalPrefixFormattingRule = element.getAttribute("nationalPrefixFormattingRule");
        nationalPrefixFormattingRule = nationalPrefixFormattingRule.replaceFirst("\\$NP", nationalPrefix).replaceFirst("\\$FG", "\\$1");
        return nationalPrefixFormattingRule;
    }

    private static String getDomesticCarrierCodeFormattingRuleFromElement(Element element, String nationalPrefix) {
        String carrierCodeFormattingRule = element.getAttribute("carrierCodeFormattingRule");
        carrierCodeFormattingRule = carrierCodeFormattingRule.replaceFirst("\\$FG", "\\$1").replaceFirst("\\$NP", nationalPrefix);
        return carrierCodeFormattingRule;
    }

    private static Phonemetadata.PhoneNumberDesc.Builder processPhoneNumberDescElement(Phonemetadata.PhoneNumberDesc.Builder generalDesc, Element countryElement, String numberType) {
        NodeList phoneNumberDescList = countryElement.getElementsByTagName(numberType);
        Phonemetadata.PhoneNumberDesc.Builder numberDesc = Phonemetadata.PhoneNumberDesc.newBuilder();
        if (!(phoneNumberDescList.getLength() != 0 || numberType.equals("fixedLine") || numberType.equals("mobile") || numberType.equals("generalDesc"))) {
            numberDesc.setNationalNumberPattern("NA");
            numberDesc.setPossibleNumberPattern("NA");
            return numberDesc;
        }
        numberDesc.mergeFrom(generalDesc.build());
        if (phoneNumberDescList.getLength() > 0) {
            NodeList exampleNumber;
            NodeList validPattern;
            Element element = (Element)phoneNumberDescList.item(0);
            NodeList possiblePattern = element.getElementsByTagName("possibleNumberPattern");
            if (possiblePattern.getLength() > 0) {
                numberDesc.setPossibleNumberPattern(BuildMetadataFromXml.validateRE(possiblePattern.item(0).getFirstChild().getNodeValue(), true));
            }
            if ((validPattern = element.getElementsByTagName("nationalNumberPattern")).getLength() > 0) {
                numberDesc.setNationalNumberPattern(BuildMetadataFromXml.validateRE(validPattern.item(0).getFirstChild().getNodeValue(), true));
            }
            if (!liteBuild.booleanValue() && (exampleNumber = element.getElementsByTagName("exampleNumber")).getLength() > 0) {
                numberDesc.setExampleNumber(exampleNumber.item(0).getFirstChild().getNodeValue());
            }
        }
        return numberDesc;
    }
}

