/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.tools.BuildMetadataFromXml;
import com.google.i18n.phonenumbers.tools.Command;
import com.google.i18n.phonenumbers.tools.CopyrightNotice;
import com.google.i18n.phonenumbers.tools.JSArrayBuilder;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMetadataJsonFromXml
extends Command {
    private static final String NAMESPACE = "i18n.phonenumbers.metadata";
    private static final String HELP_MESSAGE = "Usage:\nBuildMetadataJsonFromXml <inputFile> <outputFile> [<liteBuild>]\n\nwhere:\n  inputFile    The input file containing phone number metadata in XML format.\n  outputFile   The output file to contain phone number metadata in JSON format.\n  liteBuild    Whether to generate the lite-version of the metadata (default:\n               false). When set to true certain metadata will be omitted.\n               At this moment, example numbers information is omitted.\n\nExample command line invocation:\nBuildMetadataJsonFromXml PhoneNumberMetadata.xml metadatalite.js true\n";
    private static final String FILE_OVERVIEW = "/**\n * @fileoverview Generated metadata for file\n * %s\n * @author Nikolaos Trogkanis\n */\n\n";
    private static final String COUNTRY_CODE_TO_REGION_CODE_MAP_COMMENT = "/**\n * A mapping from a country calling code to the region codes which denote the\n * region represented by that country calling code. In the case of multiple\n * countries sharing a calling code, such as the NANPA regions, the one\n * indicated with \"isMainCountryForCode\" in the metadata should be first.\n * @type {Object.<number, Array.<string>>}\n */\n";
    private static final String COUNTRY_TO_METADATA_COMMENT = "/**\n * A mapping from a region code to the PhoneMetadata for that region.\n * @type {Object.<string, Array>}\n */\n";

    @Override
    public String getCommandName() {
        return "BuildMetadataJsonFromXml";
    }

    @Override
    public boolean start() {
        String[] args = this.getArgs();
        if (args.length != 3 && args.length != 4) {
            System.err.println(HELP_MESSAGE);
            return false;
        }
        String inputFile = args[1];
        String outputFile = args[2];
        boolean liteBuild = args.length > 3 && args[3].equals("true");
        try {
            Phonemetadata.PhoneMetadataCollection metadataCollection = BuildMetadataFromXml.buildPhoneMetadataCollection(inputFile, liteBuild);
            Map<Integer, List<String>> countryCodeToRegionCodeMap = BuildMetadataFromXml.buildCountryCodeToRegionCodeMap(metadataCollection);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write(CopyrightNotice.TEXT);
            Formatter formatter = new Formatter(writer);
            formatter.format(FILE_OVERVIEW, inputFile);
            writer.write("goog.provide('i18n.phonenumbers.metadata');\n\n");
            writer.write(COUNTRY_CODE_TO_REGION_CODE_MAP_COMMENT);
            writer.write("i18n.phonenumbers.metadata.countryCodeToRegionCodeMap = ");
            BuildMetadataJsonFromXml.writeCountryCodeToRegionCodeMap(countryCodeToRegionCodeMap, writer);
            writer.write(";\n\n");
            writer.write(COUNTRY_TO_METADATA_COMMENT);
            writer.write("i18n.phonenumbers.metadata.countryToMetadata = ");
            BuildMetadataJsonFromXml.writeCountryToMetadataMap(metadataCollection, writer);
            writer.write(";\n");
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            System.err.println(HELP_MESSAGE);
            return false;
        }
        return true;
    }

    private static void writeCountryToMetadataMap(Phonemetadata.PhoneMetadataCollection metadataCollection, BufferedWriter writer) throws IOException {
        writer.write("{\n");
        boolean isFirstTimeInLoop = true;
        for (Phonemetadata.PhoneMetadata metadata : metadataCollection.getMetadataList()) {
            if (isFirstTimeInLoop) {
                isFirstTimeInLoop = false;
            } else {
                writer.write(",");
            }
            String regionCode = metadata.getId();
            JSArrayBuilder jsArrayBuilder = new JSArrayBuilder();
            BuildMetadataJsonFromXml.toJsArray(metadata, jsArrayBuilder);
            writer.write("\"");
            writer.write(regionCode);
            writer.write("\":");
            writer.write(jsArrayBuilder.toString());
        }
        writer.write("}");
    }

    private static void writeCountryCodeToRegionCodeMap(Map<Integer, List<String>> countryCodeToRegionCodeMap, BufferedWriter writer) throws IOException {
        writer.write("{\n");
        boolean isFirstTimeInLoop = true;
        for (Map.Entry<Integer, List<String>> entry : countryCodeToRegionCodeMap.entrySet()) {
            if (isFirstTimeInLoop) {
                isFirstTimeInLoop = false;
            } else {
                writer.write(",");
            }
            writer.write(Integer.toString(entry.getKey()));
            writer.write(":");
            JSArrayBuilder jsArrayBuilder = new JSArrayBuilder();
            jsArrayBuilder.beginArray();
            jsArrayBuilder.appendIterator(entry.getValue().iterator());
            jsArrayBuilder.endArray();
            writer.write(jsArrayBuilder.toString());
        }
        writer.write("}");
    }

    private static void toJsArray(Phonemetadata.NumberFormat format, JSArrayBuilder jsArrayBuilder) {
        jsArrayBuilder.beginArray();
        jsArrayBuilder.append(null);
        jsArrayBuilder.append(format.getPattern());
        jsArrayBuilder.append(format.getFormat());
        int leadingDigitsPatternSize = format.leadingDigitsPatternSize();
        if (leadingDigitsPatternSize > 0) {
            jsArrayBuilder.beginArray();
            for (int i = 0; i < leadingDigitsPatternSize; ++i) {
                jsArrayBuilder.append(format.getLeadingDigitsPattern(i));
            }
            jsArrayBuilder.endArray();
        } else {
            jsArrayBuilder.append(null);
        }
        if (format.hasNationalPrefixFormattingRule()) {
            jsArrayBuilder.append(format.getNationalPrefixFormattingRule());
        } else {
            jsArrayBuilder.append(null);
        }
        if (format.hasDomesticCarrierCodeFormattingRule()) {
            jsArrayBuilder.append(format.getDomesticCarrierCodeFormattingRule());
        } else {
            jsArrayBuilder.append(null);
        }
        jsArrayBuilder.endArray();
    }

    private static void toJsArray(Phonemetadata.PhoneNumberDesc desc, JSArrayBuilder jsArrayBuilder) {
        jsArrayBuilder.beginArray();
        jsArrayBuilder.append(null);
        jsArrayBuilder.append(null);
        if (desc.hasNationalNumberPattern()) {
            jsArrayBuilder.append(desc.getNationalNumberPattern());
        } else {
            jsArrayBuilder.append(null);
        }
        if (desc.hasPossibleNumberPattern()) {
            jsArrayBuilder.append(desc.getPossibleNumberPattern());
        } else {
            jsArrayBuilder.append(null);
        }
        jsArrayBuilder.append(null);
        jsArrayBuilder.append(null);
        if (desc.hasExampleNumber()) {
            jsArrayBuilder.append(desc.getExampleNumber());
        } else {
            jsArrayBuilder.append(null);
        }
        jsArrayBuilder.endArray();
    }

    private static void toJsArray(Phonemetadata.PhoneMetadata metadata, JSArrayBuilder jsArrayBuilder) {
        jsArrayBuilder.beginArray();
        jsArrayBuilder.append(null);
        BuildMetadataJsonFromXml.toJsArray(metadata.getGeneralDesc(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getFixedLine(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getMobile(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getTollFree(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getPremiumRate(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getSharedCost(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getPersonalNumber(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getVoip(), jsArrayBuilder);
        jsArrayBuilder.append(metadata.getId());
        jsArrayBuilder.append(metadata.getCountryCode());
        jsArrayBuilder.append(metadata.getInternationalPrefix());
        if (metadata.hasNationalPrefix()) {
            jsArrayBuilder.append(metadata.getNationalPrefix());
        } else {
            jsArrayBuilder.append(null);
        }
        if (metadata.hasPreferredExtnPrefix()) {
            jsArrayBuilder.append(metadata.getPreferredExtnPrefix());
        } else {
            jsArrayBuilder.append(null);
        }
        jsArrayBuilder.append(null);
        if (metadata.hasNationalPrefixForParsing()) {
            jsArrayBuilder.append(metadata.getNationalPrefixForParsing());
        } else {
            jsArrayBuilder.append(null);
        }
        if (metadata.hasNationalPrefixTransformRule()) {
            jsArrayBuilder.append(metadata.getNationalPrefixTransformRule());
        } else {
            jsArrayBuilder.append(null);
        }
        if (metadata.hasPreferredInternationalPrefix()) {
            jsArrayBuilder.append(metadata.getPreferredInternationalPrefix());
        } else {
            jsArrayBuilder.append(null);
        }
        if (metadata.isSameMobileAndFixedLinePattern()) {
            jsArrayBuilder.append(1);
        } else {
            jsArrayBuilder.append(null);
        }
        int numberFormatSize = metadata.numberFormatSize();
        if (numberFormatSize > 0) {
            jsArrayBuilder.beginArray();
            for (int i = 0; i < numberFormatSize; ++i) {
                BuildMetadataJsonFromXml.toJsArray(metadata.getNumberFormat(i), jsArrayBuilder);
            }
            jsArrayBuilder.endArray();
        } else {
            jsArrayBuilder.append(null);
        }
        int intlNumberFormatSize = metadata.intlNumberFormatSize();
        if (intlNumberFormatSize > 0) {
            jsArrayBuilder.beginArray();
            for (int i = 0; i < intlNumberFormatSize; ++i) {
                BuildMetadataJsonFromXml.toJsArray(metadata.getIntlNumberFormat(i), jsArrayBuilder);
            }
            jsArrayBuilder.endArray();
        } else {
            jsArrayBuilder.append(null);
        }
        BuildMetadataJsonFromXml.toJsArray(metadata.getPager(), jsArrayBuilder);
        if (metadata.isMainCountryForCode()) {
            jsArrayBuilder.append(1);
        } else {
            jsArrayBuilder.append(null);
        }
        if (metadata.hasLeadingDigits()) {
            jsArrayBuilder.append(metadata.getLeadingDigits());
        } else {
            jsArrayBuilder.append(null);
        }
        BuildMetadataJsonFromXml.toJsArray(metadata.getNoInternationalDialling(), jsArrayBuilder);
        BuildMetadataJsonFromXml.toJsArray(metadata.getUan(), jsArrayBuilder);
        if (metadata.isLeadingZeroPossible()) {
            jsArrayBuilder.append(1);
        } else {
            jsArrayBuilder.append(null);
        }
        jsArrayBuilder.endArray();
    }
}

