/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import com.google.i18n.phonenumbers.geocoding.AreaCodeMap;
import com.google.i18n.phonenumbers.geocoding.MappingFileProvider;
import com.google.i18n.phonenumbers.tools.Command;
import com.google.i18n.phonenumbers.tools.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateAreaCodeData
extends Command {
    private final File inputPath;
    private final File outputPath;
    private final boolean forTesting;
    private static final Logger LOGGER = Logger.getLogger(GenerateAreaCodeData.class.getName());

    public GenerateAreaCodeData() {
        this.inputPath = null;
        this.outputPath = null;
        this.forTesting = false;
    }

    public GenerateAreaCodeData(File inputPath, File outputPath, boolean forTesting) throws IOException {
        if (!inputPath.isDirectory()) {
            throw new IOException("The provided input path does not exist: " + inputPath.getAbsolutePath());
        }
        if (outputPath.exists()) {
            if (!outputPath.isDirectory()) {
                throw new IOException("Expected directory: " + outputPath.getAbsolutePath());
            }
        } else if (!outputPath.mkdirs()) {
            throw new IOException("Could not create directory " + outputPath.getAbsolutePath());
        }
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.forTesting = forTesting;
    }

    private static void closeFile(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getMessage());
        }
    }

    static void convertData(InputStream input, OutputStream output) throws IOException {
        String line;
        TreeMap<Integer, String> areaCodeMapTemp = new TreeMap<Integer, String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(input), Charset.forName("UTF-8")));
        while ((line = bufferedReader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            int indexOfPipe = line.indexOf(124);
            if (indexOfPipe == -1) {
                LOGGER.log(Level.WARNING, "Malformatted data: expected '|'");
                continue;
            }
            String areaCode = line.substring(0, indexOfPipe);
            if (indexOfPipe == line.length() - 1) {
                LOGGER.log(Level.WARNING, "Missing location for area code " + areaCode);
                continue;
            }
            String location = line.substring(indexOfPipe + 1);
            areaCodeMapTemp.put(Integer.parseInt(areaCode), location);
        }
        AreaCodeMap areaCodeMap = new AreaCodeMap();
        areaCodeMap.readAreaCodeMap(areaCodeMapTemp);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(output);
        areaCodeMap.writeExternal(objectOutputStream);
        objectOutputStream.flush();
    }

    private List<Pair<File, File>> createInputOutputFileMappings() {
        File[] languageDirectories;
        ArrayList<Pair<File, File>> mappings = new ArrayList<Pair<File, File>>();
        for (File languageDirectory : languageDirectories = this.inputPath.listFiles()) {
            File[] countryCodeFiles;
            if (!languageDirectory.isDirectory() || languageDirectory.isHidden()) continue;
            for (File countryCodeFile : countryCodeFiles = languageDirectory.listFiles()) {
                if (countryCodeFile.isHidden()) continue;
                String countryCodeFileName = countryCodeFile.getName();
                int indexOfDot = countryCodeFileName.indexOf(46);
                if (indexOfDot == -1) {
                    LOGGER.log(Level.WARNING, String.format("unexpected file name %s, expected pattern .*\\.txt", countryCodeFileName));
                    continue;
                }
                String countryCode = countryCodeFileName.substring(0, indexOfDot);
                if (!countryCode.matches("\\d+")) {
                    LOGGER.log(Level.WARNING, "ignoring unexpected file " + countryCodeFileName);
                    continue;
                }
                mappings.add(new Pair<File, File>(countryCodeFile, new File(this.outputPath, String.format("%s_%s", countryCode, languageDirectory.getName()))));
            }
        }
        return mappings;
    }

    static void addConfigurationMapping(SortedMap<Integer, Set<String>> availableDataFiles, File outputAreaCodeMappingsFile) {
        String outputAreaCodeMappingsFileName = outputAreaCodeMappingsFile.getName();
        int indexOfUnderscore = outputAreaCodeMappingsFileName.indexOf(95);
        int countryCode = Integer.parseInt(outputAreaCodeMappingsFileName.substring(0, indexOfUnderscore));
        String language = outputAreaCodeMappingsFileName.substring(indexOfUnderscore + 1);
        HashSet<String> languageSet = (HashSet<String>)availableDataFiles.get(countryCode);
        if (languageSet == null) {
            languageSet = new HashSet<String>();
            availableDataFiles.put(countryCode, languageSet);
        }
        languageSet.add(language);
    }

    static void outputBinaryConfiguration(SortedMap<Integer, Set<String>> availableDataFiles, OutputStream outputStream) throws IOException {
        MappingFileProvider mappingFileProvider = new MappingFileProvider();
        mappingFileProvider.readFileConfigs(availableDataFiles);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        mappingFileProvider.writeExternal(objectOutputStream);
        objectOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws FileNotFoundException, IOException {
        if (!FileUtils.isGenerationRequired(this.inputPath, this.outputPath)) {
            LOGGER.log(Level.INFO, "Geocoding data up-to-date.");
            return;
        }
        List<Pair<File, File>> inputOutputMappings = this.createInputOutputFileMappings();
        TreeMap<Integer, Set<String>> availableDataFiles = new TreeMap<Integer, Set<String>>();
        for (Pair<File, File> inputOutputMapping : inputOutputMappings) {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                File textFile = (File)inputOutputMapping.first;
                File binaryFile = (File)inputOutputMapping.second;
                fileInputStream = new FileInputStream(textFile);
                fileOutputStream = new FileOutputStream(binaryFile);
                GenerateAreaCodeData.convertData(fileInputStream, fileOutputStream);
                GenerateAreaCodeData.addConfigurationMapping(availableDataFiles, (File)inputOutputMapping.second);
                GenerateAreaCodeData.closeFile(fileInputStream);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                continue;
            }
            finally {
                GenerateAreaCodeData.closeFile(fileInputStream);
                GenerateAreaCodeData.closeFile(fileOutputStream);
                continue;
            }
            GenerateAreaCodeData.closeFile(fileOutputStream);
        }
        FileOutputStream fileOutputStream = null;
        try {
            File configFile = new File(this.outputPath, "config");
            fileOutputStream = new FileOutputStream(configFile);
            GenerateAreaCodeData.outputBinaryConfiguration(availableDataFiles, fileOutputStream);
        }
        catch (Throwable throwable) {
            GenerateAreaCodeData.closeFile(fileOutputStream);
            throw throwable;
        }
        GenerateAreaCodeData.closeFile(fileOutputStream);
        LOGGER.log(Level.INFO, "Geocoding data successfully generated.");
    }

    @Override
    public String getCommandName() {
        return "GenerateAreaCodeData";
    }

    @Override
    public boolean start() {
        String[] args = this.getArgs();
        if (args.length != 4) {
            LOGGER.log(Level.SEVERE, "usage: GenerateAreaCodeData /path/to/input/directory /path/to/output/directory forTesting");
            return false;
        }
        try {
            GenerateAreaCodeData generateAreaCodeData = new GenerateAreaCodeData(new File(args[1]), new File(args[2]), Boolean.parseBoolean(args[3]));
            generateAreaCodeData.run();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Pair<A, B> {
        public final A first;
        public final B second;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }
    }
}

