/*
 * Copyright (C) 2013 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by {@link BuildMetadataProtoFromXml}.
 * Please don't modify it directly.
 */

package com.google.i18n.phonenumbers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountryCodeToRegionCodeMapForShortNumbers {
  // A mapping from a country code to the region codes which denote the
  // country/region represented by that country code. In the case of multiple
  // countries sharing a calling code, such as the NANPA countries, the one
  // indicated with "isMainCountryForCode" in the metadata should be first.
  static Map<Integer, List<String>> getCountryCodeToRegionCodeMap() {
    // The capacity is set to 1 as there are 1 different country codes,
    // and this offers a load factor of roughly 0.75.
    Map<Integer, List<String>> countryCodeToRegionCodeMap =
        new HashMap<Integer, List<String>>(1);

    ArrayList<String> listWithRegionCode;

    listWithRegionCode = new ArrayList<String>(49);
    listWithRegionCode.add("AM");
    listWithRegionCode.add("AR");
    listWithRegionCode.add("BD");
    listWithRegionCode.add("CR");
    listWithRegionCode.add("CU");
    listWithRegionCode.add("CZ");
    listWithRegionCode.add("DE");
    listWithRegionCode.add("EE");
    listWithRegionCode.add("FR");
    listWithRegionCode.add("FJ");
    listWithRegionCode.add("FK");
    listWithRegionCode.add("FO");
    listWithRegionCode.add("GB");
    listWithRegionCode.add("GG");
    listWithRegionCode.add("GI");
    listWithRegionCode.add("GT");
    listWithRegionCode.add("GY");
    listWithRegionCode.add("HT");
    listWithRegionCode.add("IL");
    listWithRegionCode.add("IM");
    listWithRegionCode.add("IT");
    listWithRegionCode.add("JE");
    listWithRegionCode.add("JO");
    listWithRegionCode.add("KE");
    listWithRegionCode.add("KI");
    listWithRegionCode.add("KW");
    listWithRegionCode.add("LI");
    listWithRegionCode.add("LU");
    listWithRegionCode.add("MD");
    listWithRegionCode.add("ME");
    listWithRegionCode.add("MU");
    listWithRegionCode.add("MV");
    listWithRegionCode.add("MZ");
    listWithRegionCode.add("NA");
    listWithRegionCode.add("NC");
    listWithRegionCode.add("NL");
    listWithRegionCode.add("NR");
    listWithRegionCode.add("PA");
    listWithRegionCode.add("PY");
    listWithRegionCode.add("QA");
    listWithRegionCode.add("RS");
    listWithRegionCode.add("SA");
    listWithRegionCode.add("SB");
    listWithRegionCode.add("SC");
    listWithRegionCode.add("SG");
    listWithRegionCode.add("SH");
    listWithRegionCode.add("SR");
    listWithRegionCode.add("TL");
    listWithRegionCode.add("UY");
    countryCodeToRegionCodeMap.put(0, listWithRegionCode);

    return countryCodeToRegionCodeMap;
  }
}
