/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.BuildMetadataFromXml;
import com.google.i18n.phonenumbers.Command;
import com.google.i18n.phonenumbers.CppMetadataGenerator;
import com.google.i18n.phonenumbers.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildMetadataCppFromXml
extends Command {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public String getCommandName() {
        return "BuildMetadataCppFromXml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        try {
            Options opt = Options.parse(this.getCommandName(), this.getArgs());
            byte[] data = this.loadMetadataBytes(opt.getInputFilePath(), opt.getVariant() == Variant.LITE);
            CppMetadataGenerator metadata = CppMetadataGenerator.create(opt.getType(), data);
            OutputStream headerStream = null;
            OutputStream sourceStream = null;
            try {
                File dir = new File(opt.getOutputDir());
                headerStream = this.openHeaderStream(dir, opt.getType());
                sourceStream = this.openSourceStream(dir, opt.getType(), opt.getVariant());
                metadata.outputHeaderFile(new OutputStreamWriter(headerStream, UTF_8));
                metadata.outputSourceFile(new OutputStreamWriter(sourceStream, UTF_8));
            }
            catch (Throwable throwable) {
                FileUtils.closeFiles(headerStream, sourceStream);
                throw throwable;
            }
            FileUtils.closeFiles(headerStream, sourceStream);
            return true;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
        }
        return false;
    }

    private byte[] loadMetadataBytes(String inputFilePath, boolean liteMetadata) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writePhoneMetadataCollection(inputFilePath, liteMetadata, out);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.closeFiles(out);
                throw throwable;
            }
        }
        FileUtils.closeFiles(out);
        return out.toByteArray();
    }

    void writePhoneMetadataCollection(String inputFilePath, boolean liteMetadata, OutputStream out) throws IOException, Exception {
        BuildMetadataFromXml.buildPhoneMetadataCollection(inputFilePath, liteMetadata).writeTo(out);
    }

    OutputStream openHeaderStream(File dir, CppMetadataGenerator.Type type) throws FileNotFoundException {
        String string = String.valueOf((Object)type);
        return new FileOutputStream(new File(dir, new StringBuilder(2 + String.valueOf(string).length()).append(string).append(".h").toString()));
    }

    OutputStream openSourceStream(File dir, CppMetadataGenerator.Type type, Variant variant) throws FileNotFoundException {
        return new FileOutputStream(new File(dir, String.valueOf(variant.getBasename(type)).concat(".cc")));
    }

    static final class Options {
        private static final Pattern BASENAME_PATTERN = Pattern.compile("(?:(test|lite)_)?([a-z_]+)");
        private final String inputXmlFilePath;
        private final String outputDirPath;
        private final CppMetadataGenerator.Type type;
        private final Variant variant;

        public static Options parse(String commandName, String[] args) {
            if (args.length == 4) {
                String inputXmlFilePath = args[1];
                String outputDirPath = args[2];
                Matcher basenameMatcher = BASENAME_PATTERN.matcher(args[3]);
                if (basenameMatcher.matches()) {
                    Variant variant = Variant.parse(basenameMatcher.group(1));
                    CppMetadataGenerator.Type type = CppMetadataGenerator.Type.parse(basenameMatcher.group(2));
                    if (type != null && variant != null) {
                        return new Options(inputXmlFilePath, outputDirPath, type, variant);
                    }
                }
            }
            throw new IllegalArgumentException(String.format("Usage: %s <inputXmlFile> <outputDir> ( <type> | test_<type> | lite_<type> )\n       where <type> is one of: %s", commandName, Arrays.asList(CppMetadataGenerator.Type.values())));
        }

        private Options(String inputXmlFilePath, String outputDirPath, CppMetadataGenerator.Type type, Variant variant) {
            this.inputXmlFilePath = inputXmlFilePath;
            this.outputDirPath = outputDirPath;
            this.type = type;
            this.variant = variant;
        }

        public String getInputFilePath() {
            return this.inputXmlFilePath;
        }

        public String getOutputDir() {
            return this.outputDirPath;
        }

        public CppMetadataGenerator.Type getType() {
            return this.type;
        }

        public Variant getVariant() {
            return this.variant;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Variant {
        FULL("%s"),
        TEST("test_%s"),
        LITE("lite_%s");

        private final String template;

        private Variant(String template) {
            this.template = template;
        }

        public String getBasename(CppMetadataGenerator.Type type) {
            return String.format(this.template, new Object[]{type});
        }

        public static Variant parse(String variantName) {
            if ("test".equalsIgnoreCase(variantName)) {
                return TEST;
            }
            if ("lite".equalsIgnoreCase(variantName)) {
                return LITE;
            }
            if (variantName == null || variantName.length() == 0) {
                return FULL;
            }
            return null;
        }
    }
}

