/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.tools.BuildMetadataFromXml;
import com.google.i18n.phonenumbers.tools.Command;
import com.google.i18n.phonenumbers.tools.CopyrightNotice;
import com.google.i18n.phonenumbers.tools.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Formatter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMetadataProtoFromXml
extends Command {
    private static final String PACKAGE_NAME = "com/google/i18n/phonenumbers";
    private static final String META_DATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private static final String TEST_META_DATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProtoForTesting";
    private static final String TEST_COUNTRY_CODE_TO_REGION_CODE_MAP_CLASS_NAME = "CountryCodeToRegionCodeMapForTesting";
    private static final String COUNTRY_CODE_TO_REGION_CODE_MAP_CLASS_NAME = "CountryCodeToRegionCodeMap";
    private static final String HELP_MESSAGE = "Usage:\nBuildMetadataProtoFromXml <inputFile> <outputDir> <forTesting> [<liteBuild>]\n\nwhere:\n  inputFile    The input file containing phone number metadata in XML format.\n  outputDir    The output source directory to store phone number metadata in proto\n               format (one file per region) and the country code to region code\n               mapping file.\n  forTesting   Flag whether to generate metadata for testing purposes or not.\n  liteBuild    Whether to generate the lite-version of the metadata (default:\n               false). When set to true certain metadata will be omitted.\n               At this moment, example numbers information is omitted.\n\nMetadata will be stored in:\n  <outputDir>/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto_*\nMapping file will be stored in:\n  <outputDir>/com/google/i18n/phonenumbers/CountryCodeToRegionCodeMap.java\n\nExample command line invocation:\nBuildMetadataProtoFromXml PhoneNumberMetadata.xml src false false\n";
    private static final String GENERATION_COMMENT = "/* This file is automatically generated by {@link BuildMetadataProtoFromXml}.\n * Please don't modify it directly.\n */\n";
    private static final String MAPPING_IMPORTS = "import java.util.ArrayList;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\n";
    private static final String MAPPING_COMMENT = "  // A mapping from a country code to the region codes which denote the\n  // country/region represented by that country code. In the case of multiple\n  // countries sharing a calling code, such as the NANPA countries, the one\n  // indicated with \"isMainCountryForCode\" in the metadata should be first.\n";
    private static final double MAPPING_LOAD_FACTOR = 0.75;
    private static final String MAPPING_COMMENT_2 = "    // The capacity is set to %d as there are %d different country codes,\n    // and this offers a load factor of roughly 0.75.\n";

    @Override
    public String getCommandName() {
        return "BuildMetadataProtoFromXml";
    }

    @Override
    public boolean start() {
        boolean liteBuild;
        String[] args = this.getArgs();
        if (args.length != 4 && args.length != 5) {
            System.err.println(HELP_MESSAGE);
            return false;
        }
        String inputFile = args[1];
        String outputDir = args[2];
        boolean forTesting = args[3].equals("true");
        boolean bl = liteBuild = args.length > 4 && args[4].equals("true");
        if (!FileUtils.isGenerationRequired(new File(inputFile), new File(outputDir, new File(META_DATA_FILE_PREFIX).getParent()))) {
            System.out.println("Metadata code up-to-date.");
            return true;
        }
        String filePrefix = forTesting ? outputDir + TEST_META_DATA_FILE_PREFIX : outputDir + META_DATA_FILE_PREFIX;
        try {
            Phonemetadata.PhoneMetadataCollection metadataCollection = BuildMetadataFromXml.buildPhoneMetadataCollection(inputFile, liteBuild);
            for (Phonemetadata.PhoneMetadata metadata : metadataCollection.getMetadataList()) {
                String regionCode = metadata.getId();
                Phonemetadata.PhoneMetadataCollection outMetadataCollection = new Phonemetadata.PhoneMetadataCollection();
                outMetadataCollection.addMetadata(metadata);
                FileOutputStream outputForRegion = new FileOutputStream(filePrefix + "_" + regionCode);
                ObjectOutputStream out = new ObjectOutputStream(outputForRegion);
                outMetadataCollection.writeExternal(out);
                out.close();
            }
            Map<Integer, List<String>> countryCodeToRegionCodeMap = BuildMetadataFromXml.buildCountryCodeToRegionCodeMap(metadataCollection);
            BuildMetadataProtoFromXml.writeCountryCallingCodeMappingToJavaFile(countryCodeToRegionCodeMap, outputDir, forTesting);
        }
        catch (Exception e) {
            System.err.println(HELP_MESSAGE);
            return false;
        }
        System.out.println("Metadata code successfully generated.");
        return true;
    }

    private static void writeCountryCallingCodeMappingToJavaFile(Map<Integer, List<String>> countryCodeToRegionCodeMap, String outputDir, boolean forTesting) throws IOException {
        String mappingClassName = forTesting ? TEST_COUNTRY_CODE_TO_REGION_CODE_MAP_CLASS_NAME : COUNTRY_CODE_TO_REGION_CODE_MAP_CLASS_NAME;
        String mappingFile = outputDir + "/" + PACKAGE_NAME + "/" + mappingClassName + ".java";
        int capacity = (int)((double)countryCodeToRegionCodeMap.size() / 0.75);
        BufferedWriter writer = new BufferedWriter(new FileWriter(mappingFile));
        writer.write(CopyrightNotice.TEXT + "\n" + GENERATION_COMMENT + "\n");
        if (PACKAGE_NAME.length() > 0) {
            writer.write("package " + PACKAGE_NAME.replaceAll("/", ".") + ";\n\n");
        }
        writer.write(MAPPING_IMPORTS);
        writer.write("\n");
        writer.write("public class " + mappingClassName + " {\n");
        writer.write(MAPPING_COMMENT);
        writer.write("  static Map<Integer, List<String>> getCountryCodeToRegionCodeMap() {\n");
        Formatter formatter = new Formatter(writer);
        formatter.format(MAPPING_COMMENT_2, capacity, countryCodeToRegionCodeMap.size());
        writer.write("    Map<Integer, List<String>> countryCodeToRegionCodeMap =\n");
        writer.write("        new HashMap<Integer, List<String>>(" + capacity + ");\n");
        writer.write("\n");
        writer.write("    ArrayList<String> listWithRegionCode;\n");
        writer.write("\n");
        for (Map.Entry<Integer, List<String>> entry : countryCodeToRegionCodeMap.entrySet()) {
            int countryCallingCode = entry.getKey();
            List<String> regionCodes = entry.getValue();
            writer.write("    listWithRegionCode = new ArrayList<String>(" + regionCodes.size() + ");\n");
            for (String regionCode : regionCodes) {
                writer.write("    listWithRegionCode.add(\"" + regionCode + "\");\n");
            }
            writer.write("    countryCodeToRegionCodeMap.put(" + countryCallingCode + ", listWithRegionCode);\n");
            writer.write("\n");
        }
        writer.write("    return countryCodeToRegionCodeMap;\n");
        writer.write("  }\n");
        writer.write("}\n");
        writer.flush();
        writer.close();
    }
}

