/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSArrayBuilder
implements CharSequence {
    private StringBuilder data = new StringBuilder();
    private boolean isFirstElement = true;

    private void beginElement() {
        if (!this.isFirstElement) {
            this.data.append(',');
        }
        this.isFirstElement = false;
    }

    public JSArrayBuilder beginArray() {
        this.beginElement();
        this.data.append('[');
        this.isFirstElement = true;
        return this;
    }

    public JSArrayBuilder endArray() {
        this.trimTrailingCommas();
        this.data.append("]\n");
        this.isFirstElement = false;
        return this;
    }

    public JSArrayBuilder append(int number) {
        return this.append(Integer.toString(number), false);
    }

    public JSArrayBuilder append(String string) {
        return this.append(string, true);
    }

    public final JSArrayBuilder appendIterator(Iterator<String> iterator) {
        while (iterator.hasNext()) {
            this.append(iterator.next());
        }
        return this;
    }

    private JSArrayBuilder append(String string, boolean escapeString) {
        this.beginElement();
        if (string != null) {
            if (escapeString) {
                JSArrayBuilder.escape(string, this.data);
            } else {
                this.data.append(string);
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    private static void escape(String str, StringBuilder out) {
        out.append('\"');
        out.append(str.replaceAll("\\\\", "\\\\\\\\"));
        out.append('\"');
    }

    private void trimTrailingCommas() {
        int i;
        for (i = this.data.length(); i > 0 && this.data.charAt(i - 1) == ','; --i) {
        }
        if (i < this.data.length()) {
            this.data.delete(i, this.data.length());
        }
    }

    @Override
    public char charAt(int index) {
        return this.data.charAt(index);
    }

    @Override
    public int length() {
        return this.data.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.data.subSequence(start, end);
    }
}

