/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.MetadataFilter;
import com.google.i18n.phonenumbers.Phonemetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMetadataFromXml {
    private static final Logger logger = Logger.getLogger(BuildMetadataFromXml.class.getName());
    private static final String CARRIER_CODE_FORMATTING_RULE = "carrierCodeFormattingRule";
    private static final String CARRIER_SPECIFIC = "carrierSpecific";
    private static final String COUNTRY_CODE = "countryCode";
    private static final String EMERGENCY = "emergency";
    private static final String EXAMPLE_NUMBER = "exampleNumber";
    private static final String FIXED_LINE = "fixedLine";
    private static final String FORMAT = "format";
    private static final String GENERAL_DESC = "generalDesc";
    private static final String INTERNATIONAL_PREFIX = "internationalPrefix";
    private static final String INTL_FORMAT = "intlFormat";
    private static final String LEADING_DIGITS = "leadingDigits";
    private static final String MAIN_COUNTRY_FOR_CODE = "mainCountryForCode";
    private static final String MOBILE = "mobile";
    private static final String MOBILE_NUMBER_PORTABLE_REGION = "mobileNumberPortableRegion";
    private static final String NATIONAL_NUMBER_PATTERN = "nationalNumberPattern";
    private static final String NATIONAL_PREFIX = "nationalPrefix";
    private static final String NATIONAL_PREFIX_FORMATTING_RULE = "nationalPrefixFormattingRule";
    private static final String NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING = "nationalPrefixOptionalWhenFormatting";
    private static final String NATIONAL_PREFIX_FOR_PARSING = "nationalPrefixForParsing";
    private static final String NATIONAL_PREFIX_TRANSFORM_RULE = "nationalPrefixTransformRule";
    private static final String NO_INTERNATIONAL_DIALLING = "noInternationalDialling";
    private static final String NUMBER_FORMAT = "numberFormat";
    private static final String PAGER = "pager";
    private static final String PATTERN = "pattern";
    private static final String PERSONAL_NUMBER = "personalNumber";
    private static final String POSSIBLE_LENGTHS = "possibleLengths";
    private static final String NATIONAL = "national";
    private static final String LOCAL_ONLY = "localOnly";
    private static final String PREFERRED_EXTN_PREFIX = "preferredExtnPrefix";
    private static final String PREFERRED_INTERNATIONAL_PREFIX = "preferredInternationalPrefix";
    private static final String PREMIUM_RATE = "premiumRate";
    private static final String SHARED_COST = "sharedCost";
    private static final String SHORT_CODE = "shortCode";
    private static final String STANDARD_RATE = "standardRate";
    private static final String TOLL_FREE = "tollFree";
    private static final String UAN = "uan";
    private static final String VOICEMAIL = "voicemail";
    private static final String VOIP = "voip";
    private static final Set<String> PHONE_NUMBER_DESCS_WITHOUT_MATCHING_TYPES = new HashSet<String>(Arrays.asList("noInternationalDialling"));

    public static Phonemetadata.PhoneMetadataCollection buildPhoneMetadataCollection(String inputXmlFile, boolean liteBuild, boolean specialBuild) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        File xmlFile = new File(inputXmlFile);
        Document document = builder.parse(xmlFile);
        boolean isShortNumberMetadata = inputXmlFile.contains("ShortNumberMetadata");
        boolean isAlternateFormatsMetadata = inputXmlFile.contains("PhoneNumberAlternateFormats");
        return BuildMetadataFromXml.buildPhoneMetadataCollection(document, liteBuild, specialBuild, isShortNumberMetadata, isAlternateFormatsMetadata);
    }

    static Phonemetadata.PhoneMetadataCollection buildPhoneMetadataCollection(Document document, boolean liteBuild, boolean specialBuild, boolean isShortNumberMetadata, boolean isAlternateFormatsMetadata) throws Exception {
        document.getDocumentElement().normalize();
        Element rootElement = document.getDocumentElement();
        NodeList territory = rootElement.getElementsByTagName("territory");
        Phonemetadata.PhoneMetadataCollection.Builder metadataCollection = Phonemetadata.PhoneMetadataCollection.newBuilder();
        int numOfTerritories = territory.getLength();
        MetadataFilter metadataFilter = BuildMetadataFromXml.getMetadataFilter(liteBuild, specialBuild);
        for (int i = 0; i < numOfTerritories; ++i) {
            Element territoryElement = (Element)territory.item(i);
            String regionCode = "";
            if (territoryElement.hasAttribute("id")) {
                regionCode = territoryElement.getAttribute("id");
            }
            Phonemetadata.PhoneMetadata.Builder metadata = BuildMetadataFromXml.loadCountryMetadata(regionCode, territoryElement, isShortNumberMetadata, isAlternateFormatsMetadata);
            metadataFilter.filterMetadata(metadata);
            metadataCollection.addMetadata(metadata);
        }
        return metadataCollection.build();
    }

    public static Map<Integer, List<String>> buildCountryCodeToRegionCodeMap(Phonemetadata.PhoneMetadataCollection metadataCollection) {
        TreeMap<Integer, List<String>> countryCodeToRegionCodeMap = new TreeMap<Integer, List<String>>();
        for (Phonemetadata.PhoneMetadata metadata : metadataCollection.getMetadataList()) {
            String regionCode = metadata.getId();
            int countryCode = metadata.getCountryCode();
            if (countryCodeToRegionCodeMap.containsKey(countryCode)) {
                if (metadata.getMainCountryForCode()) {
                    ((List)countryCodeToRegionCodeMap.get(countryCode)).add(0, regionCode);
                    continue;
                }
                ((List)countryCodeToRegionCodeMap.get(countryCode)).add(regionCode);
                continue;
            }
            ArrayList<String> listWithRegionCode = new ArrayList<String>(1);
            if (!regionCode.equals("")) {
                listWithRegionCode.add(regionCode);
            }
            countryCodeToRegionCodeMap.put(countryCode, listWithRegionCode);
        }
        return countryCodeToRegionCodeMap;
    }

    private static String validateRE(String regex) {
        return BuildMetadataFromXml.validateRE(regex, false);
    }

    static String validateRE(String regex, boolean removeWhitespace) {
        String compressedRegex = removeWhitespace ? regex.replaceAll("\\s", "") : regex;
        Pattern.compile(compressedRegex);
        int errorIndex = compressedRegex.indexOf("|)");
        if (errorIndex >= 0) {
            String string = String.valueOf(String.valueOf(regex));
            logger.log(Level.SEVERE, new StringBuilder(103 + string.length()).append("Error with original regex: ").append(string).append("\n| should not be followed directly by ) in phone number regular expressions.").toString());
            throw new PatternSyntaxException("| followed by )", compressedRegex, errorIndex);
        }
        return compressedRegex;
    }

    static String getNationalPrefix(Element element) {
        return element.hasAttribute(NATIONAL_PREFIX) ? element.getAttribute(NATIONAL_PREFIX) : "";
    }

    static Phonemetadata.PhoneMetadata.Builder loadTerritoryTagMetadata(String regionCode, Element element, String nationalPrefix) {
        Phonemetadata.PhoneMetadata.Builder metadata = Phonemetadata.PhoneMetadata.newBuilder();
        metadata.setId(regionCode);
        if (element.hasAttribute(COUNTRY_CODE)) {
            metadata.setCountryCode(Integer.parseInt(element.getAttribute(COUNTRY_CODE)));
        }
        if (element.hasAttribute(LEADING_DIGITS)) {
            metadata.setLeadingDigits(BuildMetadataFromXml.validateRE(element.getAttribute(LEADING_DIGITS)));
        }
        if (element.hasAttribute(INTERNATIONAL_PREFIX)) {
            metadata.setInternationalPrefix(BuildMetadataFromXml.validateRE(element.getAttribute(INTERNATIONAL_PREFIX)));
        }
        if (element.hasAttribute(PREFERRED_INTERNATIONAL_PREFIX)) {
            metadata.setPreferredInternationalPrefix(element.getAttribute(PREFERRED_INTERNATIONAL_PREFIX));
        }
        if (element.hasAttribute(NATIONAL_PREFIX_FOR_PARSING)) {
            metadata.setNationalPrefixForParsing(BuildMetadataFromXml.validateRE(element.getAttribute(NATIONAL_PREFIX_FOR_PARSING), true));
            if (element.hasAttribute(NATIONAL_PREFIX_TRANSFORM_RULE)) {
                metadata.setNationalPrefixTransformRule(BuildMetadataFromXml.validateRE(element.getAttribute(NATIONAL_PREFIX_TRANSFORM_RULE)));
            }
        }
        if (!nationalPrefix.isEmpty()) {
            metadata.setNationalPrefix(nationalPrefix);
            if (!metadata.hasNationalPrefixForParsing()) {
                metadata.setNationalPrefixForParsing(nationalPrefix);
            }
        }
        if (element.hasAttribute(PREFERRED_EXTN_PREFIX)) {
            metadata.setPreferredExtnPrefix(element.getAttribute(PREFERRED_EXTN_PREFIX));
        }
        if (element.hasAttribute(MAIN_COUNTRY_FOR_CODE)) {
            metadata.setMainCountryForCode(true);
        }
        if (element.hasAttribute(MOBILE_NUMBER_PORTABLE_REGION)) {
            metadata.setMobileNumberPortableRegion(true);
        }
        return metadata;
    }

    static boolean loadInternationalFormat(Phonemetadata.PhoneMetadata.Builder metadata, Element numberFormatElement, Phonemetadata.NumberFormat nationalFormat) {
        Phonemetadata.NumberFormat.Builder intlFormat = Phonemetadata.NumberFormat.newBuilder();
        NodeList intlFormatPattern = numberFormatElement.getElementsByTagName(INTL_FORMAT);
        boolean hasExplicitIntlFormatDefined = false;
        if (intlFormatPattern.getLength() > 1) {
            logger.log(Level.SEVERE, "A maximum of one intlFormat pattern for a numberFormat element should be defined.");
            String countryId = metadata.getId().length() > 0 ? metadata.getId() : Integer.toString(metadata.getCountryCode());
            String string = String.valueOf(countryId);
            throw new RuntimeException(string.length() != 0 ? "Invalid number of intlFormat patterns for country: ".concat(string) : new String("Invalid number of intlFormat patterns for country: "));
        }
        if (intlFormatPattern.getLength() == 0) {
            intlFormat.mergeFrom(nationalFormat);
        } else {
            intlFormat.setPattern(numberFormatElement.getAttribute(PATTERN));
            BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, intlFormat);
            String intlFormatPatternValue = intlFormatPattern.item(0).getFirstChild().getNodeValue();
            if (!intlFormatPatternValue.equals("NA")) {
                intlFormat.setFormat(intlFormatPatternValue);
            }
            hasExplicitIntlFormatDefined = true;
        }
        if (intlFormat.hasFormat()) {
            metadata.addIntlNumberFormat(intlFormat);
        }
        return hasExplicitIntlFormatDefined;
    }

    static void loadNationalFormat(Phonemetadata.PhoneMetadata.Builder metadata, Element numberFormatElement, Phonemetadata.NumberFormat.Builder format) {
        BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, format);
        format.setPattern(BuildMetadataFromXml.validateRE(numberFormatElement.getAttribute(PATTERN)));
        NodeList formatPattern = numberFormatElement.getElementsByTagName(FORMAT);
        int numFormatPatterns = formatPattern.getLength();
        if (numFormatPatterns != 1) {
            logger.log(Level.SEVERE, "One format pattern for a numberFormat element should be defined.");
            String countryId = metadata.getId().length() > 0 ? metadata.getId() : Integer.toString(metadata.getCountryCode());
            int n = numFormatPatterns;
            String string = String.valueOf(String.valueOf(countryId));
            throw new RuntimeException(new StringBuilder(61 + string.length()).append("Invalid number of format patterns (").append(n).append(") for country: ").append(string).toString());
        }
        format.setFormat(formatPattern.item(0).getFirstChild().getNodeValue());
    }

    static void loadAvailableFormats(Phonemetadata.PhoneMetadata.Builder metadata, Element element, String nationalPrefix, String nationalPrefixFormattingRule, boolean nationalPrefixOptionalWhenFormatting) {
        String carrierCodeFormattingRule = "";
        if (element.hasAttribute(CARRIER_CODE_FORMATTING_RULE)) {
            carrierCodeFormattingRule = BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(element, nationalPrefix));
        }
        NodeList numberFormatElements = element.getElementsByTagName(NUMBER_FORMAT);
        boolean hasExplicitIntlFormatDefined = false;
        int numOfFormatElements = numberFormatElements.getLength();
        if (numOfFormatElements > 0) {
            for (int i = 0; i < numOfFormatElements; ++i) {
                Element numberFormatElement = (Element)numberFormatElements.item(i);
                Phonemetadata.NumberFormat.Builder format = Phonemetadata.NumberFormat.newBuilder();
                if (numberFormatElement.hasAttribute(NATIONAL_PREFIX_FORMATTING_RULE)) {
                    format.setNationalPrefixFormattingRule(BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(numberFormatElement, nationalPrefix));
                } else if (!nationalPrefixFormattingRule.equals("")) {
                    format.setNationalPrefixFormattingRule(nationalPrefixFormattingRule);
                }
                if (numberFormatElement.hasAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING)) {
                    format.setNationalPrefixOptionalWhenFormatting(Boolean.valueOf(numberFormatElement.getAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING)));
                } else if (format.getNationalPrefixOptionalWhenFormatting() != nationalPrefixOptionalWhenFormatting) {
                    format.setNationalPrefixOptionalWhenFormatting(nationalPrefixOptionalWhenFormatting);
                }
                if (numberFormatElement.hasAttribute(CARRIER_CODE_FORMATTING_RULE)) {
                    format.setDomesticCarrierCodeFormattingRule(BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(numberFormatElement, nationalPrefix)));
                } else if (!carrierCodeFormattingRule.equals("")) {
                    format.setDomesticCarrierCodeFormattingRule(carrierCodeFormattingRule);
                }
                BuildMetadataFromXml.loadNationalFormat(metadata, numberFormatElement, format);
                metadata.addNumberFormat(format);
                if (!BuildMetadataFromXml.loadInternationalFormat(metadata, numberFormatElement, format.build())) continue;
                hasExplicitIntlFormatDefined = true;
            }
            if (!hasExplicitIntlFormatDefined) {
                metadata.clearIntlNumberFormat();
            }
        }
    }

    static void setLeadingDigitsPatterns(Element numberFormatElement, Phonemetadata.NumberFormat.Builder format) {
        NodeList leadingDigitsPatternNodes = numberFormatElement.getElementsByTagName(LEADING_DIGITS);
        int numOfLeadingDigitsPatterns = leadingDigitsPatternNodes.getLength();
        if (numOfLeadingDigitsPatterns > 0) {
            for (int i = 0; i < numOfLeadingDigitsPatterns; ++i) {
                format.addLeadingDigitsPattern(BuildMetadataFromXml.validateRE(leadingDigitsPatternNodes.item(i).getFirstChild().getNodeValue(), true));
            }
        }
    }

    static String getNationalPrefixFormattingRuleFromElement(Element element, String nationalPrefix) {
        String nationalPrefixFormattingRule = element.getAttribute(NATIONAL_PREFIX_FORMATTING_RULE);
        nationalPrefixFormattingRule = nationalPrefixFormattingRule.replaceFirst("\\$NP", nationalPrefix).replaceFirst("\\$FG", "\\$1");
        return nationalPrefixFormattingRule;
    }

    static String getDomesticCarrierCodeFormattingRuleFromElement(Element element, String nationalPrefix) {
        String carrierCodeFormattingRule = element.getAttribute(CARRIER_CODE_FORMATTING_RULE);
        carrierCodeFormattingRule = carrierCodeFormattingRule.replaceFirst("\\$FG", "\\$1").replaceFirst("\\$NP", nationalPrefix);
        return carrierCodeFormattingRule;
    }

    private static boolean arePossibleLengthsEqual(TreeSet<Integer> possibleLengths, Phonemetadata.PhoneNumberDesc desc) {
        if (possibleLengths.size() != desc.getPossibleLengthCount()) {
            return false;
        }
        int i = 0;
        for (Integer length : possibleLengths) {
            if (length.intValue() != desc.getPossibleLength(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static Phonemetadata.PhoneNumberDesc.Builder processPhoneNumberDescElement(Phonemetadata.PhoneNumberDesc parentDesc, Element countryElement, String numberType) {
        NodeList phoneNumberDescList = countryElement.getElementsByTagName(numberType);
        Phonemetadata.PhoneNumberDesc.Builder numberDesc = Phonemetadata.PhoneNumberDesc.newBuilder();
        if (phoneNumberDescList.getLength() == 0) {
            numberDesc.addPossibleLength(-1);
            return numberDesc;
        }
        if (phoneNumberDescList.getLength() > 0) {
            NodeList exampleNumber;
            NodeList validPattern;
            if (phoneNumberDescList.getLength() > 1) {
                throw new RuntimeException(String.format("Multiple elements with type %s found.", numberType));
            }
            Element element = (Element)phoneNumberDescList.item(0);
            if (parentDesc != null) {
                TreeSet<Integer> lengths = new TreeSet<Integer>();
                TreeSet<Integer> localOnlyLengths = new TreeSet<Integer>();
                BuildMetadataFromXml.populatePossibleLengthSets(element, lengths, localOnlyLengths);
                BuildMetadataFromXml.setPossibleLengths(lengths, localOnlyLengths, parentDesc, numberDesc);
            }
            if ((validPattern = element.getElementsByTagName(NATIONAL_NUMBER_PATTERN)).getLength() > 0) {
                numberDesc.setNationalNumberPattern(BuildMetadataFromXml.validateRE(validPattern.item(0).getFirstChild().getNodeValue(), true));
            }
            if ((exampleNumber = element.getElementsByTagName(EXAMPLE_NUMBER)).getLength() > 0) {
                numberDesc.setExampleNumber(exampleNumber.item(0).getFirstChild().getNodeValue());
            }
        }
        return numberDesc;
    }

    static void setRelevantDescPatterns(Phonemetadata.PhoneMetadata.Builder metadata, Element element, boolean isShortNumberMetadata) {
        Phonemetadata.PhoneNumberDesc.Builder generalDescBuilder = BuildMetadataFromXml.processPhoneNumberDescElement(null, element, GENERAL_DESC);
        BuildMetadataFromXml.setPossibleLengthsGeneralDesc(generalDescBuilder, metadata.getId(), element, isShortNumberMetadata);
        metadata.setGeneralDesc(generalDescBuilder);
        Phonemetadata.PhoneNumberDesc generalDesc = metadata.getGeneralDesc();
        if (!isShortNumberMetadata) {
            metadata.setFixedLine(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, FIXED_LINE));
            metadata.setMobile(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, MOBILE));
            metadata.setSharedCost(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, SHARED_COST));
            metadata.setVoip(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, VOIP));
            metadata.setPersonalNumber(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PERSONAL_NUMBER));
            metadata.setPager(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PAGER));
            metadata.setUan(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, UAN));
            metadata.setVoicemail(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, VOICEMAIL));
            metadata.setNoInternationalDialling(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, NO_INTERNATIONAL_DIALLING));
            boolean mobileAndFixedAreSame = metadata.getMobile().getNationalNumberPattern().equals(metadata.getFixedLine().getNationalNumberPattern());
            if (metadata.getSameMobileAndFixedLinePattern() != mobileAndFixedAreSame) {
                metadata.setSameMobileAndFixedLinePattern(mobileAndFixedAreSame);
            }
            metadata.setTollFree(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, TOLL_FREE));
            metadata.setPremiumRate(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PREMIUM_RATE));
        } else {
            metadata.setStandardRate(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, STANDARD_RATE));
            metadata.setShortCode(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, SHORT_CODE));
            metadata.setCarrierSpecific(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, CARRIER_SPECIFIC));
            metadata.setEmergency(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, EMERGENCY));
            metadata.setTollFree(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, TOLL_FREE));
            metadata.setPremiumRate(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PREMIUM_RATE));
        }
    }

    private static Set<Integer> parsePossibleLengthStringToSet(String possibleLengthString) {
        if (possibleLengthString.length() == 0) {
            throw new RuntimeException("Empty possibleLength string found.");
        }
        String[] lengths = possibleLengthString.split(",");
        TreeSet<Integer> lengthSet = new TreeSet<Integer>();
        for (int i = 0; i < lengths.length; ++i) {
            String lengthSubstring = lengths[i];
            if (lengthSubstring.length() == 0) {
                throw new RuntimeException(String.format("Leading, trailing or adjacent commas in possible length string %s, these should only separate numbers or ranges.", possibleLengthString));
            }
            if (lengthSubstring.charAt(0) == '[') {
                if (lengthSubstring.charAt(lengthSubstring.length() - 1) != ']') {
                    throw new RuntimeException(String.format("Missing end of range character in possible length string %s.", possibleLengthString));
                }
                String[] minMax = lengthSubstring.substring(1, lengthSubstring.length() - 1).split("-");
                if (minMax.length != 2) {
                    throw new RuntimeException(String.format("Ranges must have exactly one - character: missing for %s.", possibleLengthString));
                }
                int min = Integer.parseInt(minMax[0]);
                int max = Integer.parseInt(minMax[1]);
                if (max - min < 2) {
                    throw new RuntimeException(String.format("The first number in a range should be two or more digits lower than the second. Culprit possibleLength string: %s", possibleLengthString));
                }
                for (int j = min; j <= max; ++j) {
                    if (lengthSet.add(j)) continue;
                    throw new RuntimeException(String.format("Duplicate length element found (%d) in possibleLength string %s", j, possibleLengthString));
                }
                continue;
            }
            int length = Integer.parseInt(lengthSubstring);
            if (lengthSet.add(length)) continue;
            throw new RuntimeException(String.format("Duplicate length element found (%d) in possibleLength string %s", length, possibleLengthString));
        }
        return lengthSet;
    }

    private static void populatePossibleLengthSets(Element data, TreeSet<Integer> lengths, TreeSet<Integer> localOnlyLengths) {
        NodeList possibleLengths = data.getElementsByTagName(POSSIBLE_LENGTHS);
        for (int i = 0; i < possibleLengths.getLength(); ++i) {
            Element element = (Element)possibleLengths.item(i);
            String nationalLengths = element.getAttribute(NATIONAL);
            Set<Integer> thisElementLengths = BuildMetadataFromXml.parsePossibleLengthStringToSet(nationalLengths);
            if (element.hasAttribute(LOCAL_ONLY)) {
                String localLengths = element.getAttribute(LOCAL_ONLY);
                Set<Integer> thisElementLocalOnlyLengths = BuildMetadataFromXml.parsePossibleLengthStringToSet(localLengths);
                HashSet<Integer> intersection = new HashSet<Integer>(thisElementLengths);
                intersection.retainAll(thisElementLocalOnlyLengths);
                if (!intersection.isEmpty()) {
                    throw new RuntimeException(String.format("Possible length(s) found specified as a normal and local-only length: %s", intersection));
                }
                localOnlyLengths.addAll(thisElementLocalOnlyLengths);
            }
            lengths.addAll(thisElementLengths);
        }
    }

    static void setPossibleLengthsGeneralDesc(Phonemetadata.PhoneNumberDesc.Builder generalDesc, String metadataId, Element data, boolean isShortNumberMetadata) {
        TreeSet<Integer> lengths = new TreeSet<Integer>();
        TreeSet<Integer> localOnlyLengths = new TreeSet<Integer>();
        NodeList generalDescNodes = data.getElementsByTagName(GENERAL_DESC);
        if (generalDescNodes.getLength() > 0) {
            Element generalDescNode = (Element)generalDescNodes.item(0);
            BuildMetadataFromXml.populatePossibleLengthSets(generalDescNode, lengths, localOnlyLengths);
            if (!lengths.isEmpty() || !localOnlyLengths.isEmpty()) {
                throw new RuntimeException(String.format("Found possible lengths specified at general desc: this should be derived from child elements. Affected country: %s", metadataId));
            }
        }
        if (!isShortNumberMetadata) {
            Element allDescData = (Element)data.cloneNode(true);
            for (String tag : PHONE_NUMBER_DESCS_WITHOUT_MATCHING_TYPES) {
                NodeList nodesToRemove = allDescData.getElementsByTagName(tag);
                if (nodesToRemove.getLength() <= 0) continue;
                allDescData.removeChild(nodesToRemove.item(0));
            }
            BuildMetadataFromXml.populatePossibleLengthSets(allDescData, lengths, localOnlyLengths);
        } else {
            NodeList shortCodeDescList = data.getElementsByTagName(SHORT_CODE);
            if (shortCodeDescList.getLength() > 0) {
                Element shortCodeDesc = (Element)shortCodeDescList.item(0);
                BuildMetadataFromXml.populatePossibleLengthSets(shortCodeDesc, lengths, localOnlyLengths);
            }
            if (localOnlyLengths.size() > 0) {
                throw new RuntimeException("Found local-only lengths in short-number metadata");
            }
        }
        BuildMetadataFromXml.setPossibleLengths(lengths, localOnlyLengths, null, generalDesc);
    }

    private static void setPossibleLengths(TreeSet<Integer> lengths, TreeSet<Integer> localOnlyLengths, Phonemetadata.PhoneNumberDesc parentDesc, Phonemetadata.PhoneNumberDesc.Builder desc) {
        desc.clearPossibleLength();
        desc.clearPossibleLengthLocalOnly();
        if (parentDesc == null || !BuildMetadataFromXml.arePossibleLengthsEqual(lengths, parentDesc)) {
            for (Integer length : lengths) {
                if (parentDesc == null || parentDesc.getPossibleLengthList().contains(length)) {
                    desc.addPossibleLength(length);
                    continue;
                }
                throw new RuntimeException(String.format("Out-of-range possible length found (%d), parent lengths %s.", length, parentDesc.getPossibleLengthList()));
            }
        }
        for (Integer length : localOnlyLengths) {
            if (lengths.contains(length)) continue;
            if (parentDesc == null || parentDesc.getPossibleLengthLocalOnlyList().contains(length) || parentDesc.getPossibleLengthList().contains(length)) {
                desc.addPossibleLengthLocalOnly(length);
                continue;
            }
            throw new RuntimeException(String.format("Out-of-range local-only possible length found (%d), parent length %s.", length, parentDesc.getPossibleLengthLocalOnlyList()));
        }
    }

    static Phonemetadata.PhoneMetadata.Builder loadCountryMetadata(String regionCode, Element element, boolean isShortNumberMetadata, boolean isAlternateFormatsMetadata) {
        String nationalPrefix = BuildMetadataFromXml.getNationalPrefix(element);
        Phonemetadata.PhoneMetadata.Builder metadata = BuildMetadataFromXml.loadTerritoryTagMetadata(regionCode, element, nationalPrefix);
        String nationalPrefixFormattingRule = BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(element, nationalPrefix);
        BuildMetadataFromXml.loadAvailableFormats(metadata, element, nationalPrefix, nationalPrefixFormattingRule, element.hasAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING));
        if (!isAlternateFormatsMetadata) {
            BuildMetadataFromXml.setRelevantDescPatterns(metadata, element, isShortNumberMetadata);
        }
        return metadata;
    }

    static MetadataFilter getMetadataFilter(boolean liteBuild, boolean specialBuild) {
        if (specialBuild) {
            if (liteBuild) {
                throw new RuntimeException("liteBuild and specialBuild may not both be set");
            }
            return MetadataFilter.forSpecialBuild();
        }
        if (liteBuild) {
            return MetadataFilter.forLiteBuild();
        }
        return MetadataFilter.emptyFilter();
    }
}

