/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.tools;

import com.google.i18n.phonenumbers.tools.Command;

public class CommandDispatcher {
    private final String[] args;
    private final Command[] commands;

    public CommandDispatcher(String[] args, Command[] commands) {
        this.args = args;
        this.commands = commands;
    }

    public boolean start() {
        if (this.args.length != 0) {
            String requestedCommand = this.args[0];
            for (Command command : this.commands) {
                if (!command.getCommandName().equals(requestedCommand)) continue;
                command.setArgs(this.args);
                return command.start();
            }
        }
        this.displayUsage();
        return false;
    }

    private void displayUsage() {
        StringBuilder msg = new StringBuilder("Usage: java -jar /path/to/jar [ ");
        int i = 0;
        for (Command command : this.commands) {
            msg.append(command.getCommandName());
            if (i++ == this.commands.length - 1) continue;
            msg.append(" | ");
        }
        msg.append(" ] args");
        System.err.println(msg.toString());
    }
}

