/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.Phonemetadata;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetadataFilter {
    static final TreeSet<String> EXCLUDABLE_PARENT_FIELDS = new TreeSet<String>(Arrays.asList("fixedLine", "mobile", "tollFree", "premiumRate", "sharedCost", "personalNumber", "voip", "pager", "uan", "emergency", "voicemail", "shortCode", "standardRate", "carrierSpecific", "noInternationalDialling"));
    static final TreeSet<String> EXCLUDABLE_CHILD_FIELDS = new TreeSet<String>(Arrays.asList("nationalNumberPattern", "possibleNumberPattern", "possibleLength", "possibleLengthLocalOnly", "exampleNumber"));
    static final TreeSet<String> EXCLUDABLE_CHILDLESS_FIELDS = new TreeSet<String>(Arrays.asList("preferredInternationalPrefix", "nationalPrefix", "preferredExtnPrefix", "nationalPrefixTransformRule", "sameMobileAndFixedLinePattern", "mainCountryForCode", "leadingZeroPossible", "mobileNumberPortableRegion"));
    private final TreeMap<String, TreeSet<String>> blacklist;

    static MetadataFilter forLiteBuild() {
        return new MetadataFilter(MetadataFilter.parseFieldMapFromString("exampleNumber"));
    }

    static MetadataFilter forSpecialBuild() {
        return new MetadataFilter(MetadataFilter.computeComplement(MetadataFilter.parseFieldMapFromString("mobile")));
    }

    static MetadataFilter emptyFilter() {
        return new MetadataFilter(new TreeMap<String, TreeSet<String>>());
    }

    MetadataFilter(TreeMap<String, TreeSet<String>> blacklist) {
        this.blacklist = blacklist;
    }

    public boolean equals(Object obj) {
        return this.blacklist.equals(((MetadataFilter)obj).blacklist);
    }

    public int hashCode() {
        return this.blacklist.hashCode();
    }

    void filterMetadata(Phonemetadata.PhoneMetadata.Builder metadata) {
        if (metadata.hasFixedLine()) {
            metadata.setFixedLine(this.getFiltered("fixedLine", metadata.getFixedLine()));
        }
        if (metadata.hasMobile()) {
            metadata.setMobile(this.getFiltered("mobile", metadata.getMobile()));
        }
        if (metadata.hasTollFree()) {
            metadata.setTollFree(this.getFiltered("tollFree", metadata.getTollFree()));
        }
        if (metadata.hasPremiumRate()) {
            metadata.setPremiumRate(this.getFiltered("premiumRate", metadata.getPremiumRate()));
        }
        if (metadata.hasSharedCost()) {
            metadata.setSharedCost(this.getFiltered("sharedCost", metadata.getSharedCost()));
        }
        if (metadata.hasPersonalNumber()) {
            metadata.setPersonalNumber(this.getFiltered("personalNumber", metadata.getPersonalNumber()));
        }
        if (metadata.hasVoip()) {
            metadata.setVoip(this.getFiltered("voip", metadata.getVoip()));
        }
        if (metadata.hasPager()) {
            metadata.setPager(this.getFiltered("pager", metadata.getPager()));
        }
        if (metadata.hasUan()) {
            metadata.setUan(this.getFiltered("uan", metadata.getUan()));
        }
        if (metadata.hasEmergency()) {
            metadata.setEmergency(this.getFiltered("emergency", metadata.getEmergency()));
        }
        if (metadata.hasVoicemail()) {
            metadata.setVoicemail(this.getFiltered("voicemail", metadata.getVoicemail()));
        }
        if (metadata.hasShortCode()) {
            metadata.setShortCode(this.getFiltered("shortCode", metadata.getShortCode()));
        }
        if (metadata.hasStandardRate()) {
            metadata.setStandardRate(this.getFiltered("standardRate", metadata.getStandardRate()));
        }
        if (metadata.hasCarrierSpecific()) {
            metadata.setCarrierSpecific(this.getFiltered("carrierSpecific", metadata.getCarrierSpecific()));
        }
        if (metadata.hasNoInternationalDialling()) {
            metadata.setNoInternationalDialling(this.getFiltered("noInternationalDialling", metadata.getNoInternationalDialling()));
        }
        if (this.drop("preferredInternationalPrefix")) {
            metadata.clearPreferredInternationalPrefix();
        }
        if (this.drop("nationalPrefix")) {
            metadata.clearNationalPrefix();
        }
        if (this.drop("preferredExtnPrefix")) {
            metadata.clearPreferredExtnPrefix();
        }
        if (this.drop("nationalPrefixTransformRule")) {
            metadata.clearNationalPrefixTransformRule();
        }
        if (this.drop("sameMobileAndFixedLinePattern")) {
            metadata.clearSameMobileAndFixedLinePattern();
        }
        if (this.drop("mainCountryForCode")) {
            metadata.clearMainCountryForCode();
        }
        if (this.drop("leadingZeroPossible")) {
            metadata.clearLeadingZeroPossible();
        }
        if (this.drop("mobileNumberPortableRegion")) {
            metadata.clearMobileNumberPortableRegion();
        }
    }

    static TreeMap<String, TreeSet<String>> parseFieldMapFromString(String string) {
        String string2;
        if (string == null) {
            throw new RuntimeException("Null string should not be passed to parseFieldMapFromString");
        }
        if ((string = string.replaceAll("\\s", "")).isEmpty()) {
            throw new RuntimeException("Empty string should not be passed to parseFieldMapFromString");
        }
        TreeMap<String, TreeSet<String>> fieldMap = new TreeMap<String, TreeSet<String>>();
        TreeSet<String> wildcardChildren = new TreeSet<String>();
        for (String group : string.split(":", -1)) {
            String string3;
            int leftParenIndex = group.indexOf(40);
            int rightParenIndex = group.indexOf(41);
            if (leftParenIndex < 0 && rightParenIndex < 0) {
                if (EXCLUDABLE_PARENT_FIELDS.contains(group)) {
                    if (fieldMap.containsKey(group)) {
                        string2 = String.valueOf(String.valueOf(group));
                        string3 = String.valueOf(String.valueOf(string));
                        throw new RuntimeException(new StringBuilder(25 + string2.length() + string3.length()).append(string2).append(" given more than once in ").append(string3).toString());
                    }
                    fieldMap.put(group, new TreeSet<String>((SortedSet<String>)EXCLUDABLE_CHILD_FIELDS));
                    continue;
                }
                if (EXCLUDABLE_CHILDLESS_FIELDS.contains(group)) {
                    if (fieldMap.containsKey(group)) {
                        string2 = String.valueOf(String.valueOf(group));
                        string3 = String.valueOf(String.valueOf(string));
                        throw new RuntimeException(new StringBuilder(25 + string2.length() + string3.length()).append(string2).append(" given more than once in ").append(string3).toString());
                    }
                    fieldMap.put(group, new TreeSet());
                    continue;
                }
                if (EXCLUDABLE_CHILD_FIELDS.contains(group)) {
                    if (wildcardChildren.contains(group)) {
                        string2 = String.valueOf(String.valueOf(group));
                        string3 = String.valueOf(String.valueOf(string));
                        throw new RuntimeException(new StringBuilder(25 + string2.length() + string3.length()).append(string2).append(" given more than once in ").append(string3).toString());
                    }
                    wildcardChildren.add(group);
                    continue;
                }
                throw new RuntimeException(String.valueOf(group).concat(" is not a valid token"));
            }
            if (leftParenIndex > 0 && rightParenIndex == group.length() - 1) {
                String parent = group.substring(0, leftParenIndex);
                if (!EXCLUDABLE_PARENT_FIELDS.contains(parent)) {
                    throw new RuntimeException(String.valueOf(parent).concat(" is not a valid parent token"));
                }
                if (fieldMap.containsKey(parent)) {
                    string3 = String.valueOf(String.valueOf(parent));
                    String string4 = String.valueOf(String.valueOf(string));
                    throw new RuntimeException(new StringBuilder(25 + string3.length() + string4.length()).append(string3).append(" given more than once in ").append(string4).toString());
                }
                TreeSet<String> children = new TreeSet<String>();
                for (String child : group.substring(leftParenIndex + 1, rightParenIndex).split(",", -1)) {
                    if (!EXCLUDABLE_CHILD_FIELDS.contains(child)) {
                        throw new RuntimeException(String.valueOf(child).concat(" is not a valid child token"));
                    }
                    if (children.add(child)) continue;
                    String string5 = String.valueOf(String.valueOf(child));
                    String string6 = String.valueOf(String.valueOf(group));
                    throw new RuntimeException(new StringBuilder(25 + string5.length() + string6.length()).append(string5).append(" given more than once in ").append(string6).toString());
                }
                fieldMap.put(parent, children);
                continue;
            }
            String string7 = String.valueOf(group);
            throw new RuntimeException(string7.length() != 0 ? "Incorrect location of parantheses in ".concat(string7) : new String("Incorrect location of parantheses in "));
        }
        for (String wildcardChild : wildcardChildren) {
            for (String parent : EXCLUDABLE_PARENT_FIELDS) {
                TreeSet<String> children = fieldMap.get(parent);
                if (children == null) {
                    children = new TreeSet();
                    fieldMap.put(parent, children);
                }
                if (children.add(wildcardChild) || fieldMap.get(parent).size() == EXCLUDABLE_CHILD_FIELDS.size()) continue;
                String string8 = String.valueOf(String.valueOf(wildcardChild));
                string2 = String.valueOf(String.valueOf(parent));
                throw new RuntimeException(new StringBuilder(48 + string8.length() + string2.length()).append(string8).append(" is present by itself so remove it from ").append(string2).append("'s group").toString());
            }
        }
        return fieldMap;
    }

    static TreeMap<String, TreeSet<String>> computeComplement(TreeMap<String, TreeSet<String>> fieldMap) {
        TreeMap<String, TreeSet<String>> complement = new TreeMap<String, TreeSet<String>>();
        for (String parent : EXCLUDABLE_PARENT_FIELDS) {
            if (!fieldMap.containsKey(parent)) {
                complement.put(parent, new TreeSet<String>((SortedSet<String>)EXCLUDABLE_CHILD_FIELDS));
                continue;
            }
            TreeSet<String> otherChildren = fieldMap.get(parent);
            if (otherChildren.size() == EXCLUDABLE_CHILD_FIELDS.size()) continue;
            TreeSet<String> children = new TreeSet<String>();
            for (String child : EXCLUDABLE_CHILD_FIELDS) {
                if (otherChildren.contains(child)) continue;
                children.add(child);
            }
            complement.put(parent, children);
        }
        for (String childlessField : EXCLUDABLE_CHILDLESS_FIELDS) {
            if (fieldMap.containsKey(childlessField)) continue;
            complement.put(childlessField, new TreeSet());
        }
        return complement;
    }

    boolean drop(String parent, String child) {
        if (!EXCLUDABLE_PARENT_FIELDS.contains(parent)) {
            throw new RuntimeException(String.valueOf(parent).concat(" is not an excludable parent field"));
        }
        if (!EXCLUDABLE_CHILD_FIELDS.contains(child)) {
            throw new RuntimeException(String.valueOf(child).concat(" is not an excludable child field"));
        }
        return this.blacklist.containsKey(parent) && this.blacklist.get(parent).contains(child);
    }

    boolean drop(String childlessField) {
        if (!EXCLUDABLE_CHILDLESS_FIELDS.contains(childlessField)) {
            throw new RuntimeException(String.valueOf(childlessField).concat(" is not an excludable childless field"));
        }
        return this.blacklist.containsKey(childlessField);
    }

    private Phonemetadata.PhoneNumberDesc getFiltered(String type, Phonemetadata.PhoneNumberDesc desc) {
        Phonemetadata.PhoneNumberDesc.Builder builder = Phonemetadata.PhoneNumberDesc.newBuilder().mergeFrom(desc);
        if (this.drop(type, "nationalNumberPattern")) {
            builder.clearNationalNumberPattern();
        }
        if (this.drop(type, "possibleNumberPattern")) {
            builder.clearPossibleNumberPattern();
        }
        if (this.drop(type, "possibleLength")) {
            builder.clearPossibleLength();
        }
        if (this.drop(type, "possibleLengthLocalOnly")) {
            builder.clearPossibleLengthLocalOnly();
        }
        if (this.drop(type, "exampleNumber")) {
            builder.clearExampleNumber();
        }
        return builder.build();
    }
}

