/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.AlternateFormatsCountryCodeSet;
import com.google.i18n.phonenumbers.ShortNumbersRegionCodeSet;
import com.google.i18n.phonenumbers.nano.Phonemetadata;
import com.google.protobuf.nano.CodedInputByteBufferNano;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MetadataManager {
    private static final String ALTERNATE_FORMATS_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto";
    private static final String SHORT_NUMBER_METADATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/ShortNumberMetadataProto";
    private static final Logger logger = Logger.getLogger(MetadataManager.class.getName());
    private static final Map<Integer, Phonemetadata.PhoneMetadata> callingCodeToAlternateFormatsMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Phonemetadata.PhoneMetadata> regionCodeToShortNumberMetadataMap = Collections.synchronizedMap(new HashMap());
    private static final Set<Integer> countryCodeSet = AlternateFormatsCountryCodeSet.getCountryCodeSet();
    private static final Set<String> regionCodeSet = ShortNumbersRegionCodeSet.getRegionCodeSet();
    static final int DEFAULT_BUFFER_SIZE = 16384;
    static final int ALL_REGIONS_BUFFER_SIZE = 262144;

    private MetadataManager() {
    }

    static CodedInputByteBufferNano convertStreamToByteBuffer(ObjectInputStream in, int bufferSize) throws IOException {
        int nRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[bufferSize];
        while ((nRead = in.read(data, 0, bufferSize)) != -1) {
            outputStream.write(data, 0, nRead);
        }
        outputStream.flush();
        return CodedInputByteBufferNano.newInstance(outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(InputStream source, int bufferSize) {
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ObjectInputStream(source);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load/parse metadata", e);
            }
            Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
            try {
                metadataCollection.mergeFrom(MetadataManager.convertStreamToByteBuffer(ois, bufferSize));
            }
            catch (IOException e) {
                throw new RuntimeException("cannot load/parse metadata", e);
            }
            Phonemetadata.PhoneMetadataCollection phoneMetadataCollection = metadataCollection;
            return phoneMetadataCollection;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                } else {
                    source.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing input stream (ignored)", e);
            }
        }
    }

    private static void loadAlternateFormatsMetadataFromFile(int countryCallingCode) {
        String fileName = "/com/google/i18n/phonenumbers/data/PhoneNumberAlternateFormatsProto_" + countryCallingCode;
        InputStream source = MetadataManager.class.getResourceAsStream(fileName);
        if (source == null) {
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        Phonemetadata.PhoneMetadataCollection alternateFormatData = MetadataManager.loadMetadataAndCloseInput(source, 16384);
        for (Phonemetadata.PhoneMetadata metadata : alternateFormatData.metadata) {
            callingCodeToAlternateFormatsMap.put(metadata.countryCode, metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phonemetadata.PhoneMetadata getAlternateFormatsForCountry(int countryCallingCode) {
        if (!countryCodeSet.contains(countryCallingCode)) {
            return null;
        }
        Map<Integer, Phonemetadata.PhoneMetadata> map = callingCodeToAlternateFormatsMap;
        synchronized (map) {
            if (!callingCodeToAlternateFormatsMap.containsKey(countryCallingCode)) {
                MetadataManager.loadAlternateFormatsMetadataFromFile(countryCallingCode);
            }
        }
        return callingCodeToAlternateFormatsMap.get(countryCallingCode);
    }

    private static void loadShortNumberMetadataFromFile(String regionCode) {
        String fileName = "/com/google/i18n/phonenumbers/data/ShortNumberMetadataProto_" + regionCode;
        InputStream source = MetadataManager.class.getResourceAsStream(fileName);
        if (source == null) {
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        Phonemetadata.PhoneMetadataCollection shortNumberData = MetadataManager.loadMetadataAndCloseInput(source, 16384);
        for (Phonemetadata.PhoneMetadata metadata : shortNumberData.metadata) {
            regionCodeToShortNumberMetadataMap.put(regionCode, metadata);
        }
    }

    static Set<String> getShortNumberMetadataSupportedRegions() {
        return regionCodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Phonemetadata.PhoneMetadata getShortNumberMetadataForRegion(String regionCode) {
        if (!regionCodeSet.contains(regionCode)) {
            return null;
        }
        Map<String, Phonemetadata.PhoneMetadata> map = regionCodeToShortNumberMetadataMap;
        synchronized (map) {
            if (!regionCodeToShortNumberMetadataMap.containsKey(regionCode)) {
                MetadataManager.loadShortNumberMetadataFromFile(regionCode);
            }
        }
        return regionCodeToShortNumberMetadataMap.get(regionCode);
    }
}

