/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import com.google.i18n.phonenumbers.MetadataLoader;
import com.google.i18n.phonenumbers.MetadataManager;
import com.google.i18n.phonenumbers.MetadataSource;
import com.google.i18n.phonenumbers.nano.Phonemetadata;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiFileMetadataSourceImpl
implements MetadataSource {
    private static final Logger logger = Logger.getLogger(MultiFileMetadataSourceImpl.class.getName());
    private static final String META_DATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private final ConcurrentHashMap<String, Phonemetadata.PhoneMetadata> geographicalRegions = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Phonemetadata.PhoneMetadata> nonGeographicalRegions = new ConcurrentHashMap();
    private final String filePrefix;
    private final MetadataLoader metadataLoader;

    MultiFileMetadataSourceImpl(String filePrefix, MetadataLoader metadataLoader) {
        this.filePrefix = filePrefix;
        this.metadataLoader = metadataLoader;
    }

    public MultiFileMetadataSourceImpl(MetadataLoader metadataLoader) {
        this(META_DATA_FILE_PREFIX, metadataLoader);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        Phonemetadata.PhoneMetadata metadata = this.geographicalRegions.get(regionCode);
        return metadata != null ? metadata : MultiFileMetadataSourceImpl.loadMetadataFromFile(regionCode, this.geographicalRegions, this.filePrefix, this.metadataLoader);
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        Phonemetadata.PhoneMetadata metadata = this.nonGeographicalRegions.get(countryCallingCode);
        if (metadata != null) {
            return metadata;
        }
        if (this.isNonGeographical(countryCallingCode)) {
            return MultiFileMetadataSourceImpl.loadMetadataFromFile(countryCallingCode, this.nonGeographicalRegions, this.filePrefix, this.metadataLoader);
        }
        return null;
    }

    private boolean isNonGeographical(int countryCallingCode) {
        List<String> regionCodes = CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap().get(countryCallingCode);
        return regionCodes.size() == 1 && "001".equals(regionCodes.get(0));
    }

    static <T> Phonemetadata.PhoneMetadata loadMetadataFromFile(T key, ConcurrentHashMap<T, Phonemetadata.PhoneMetadata> map, String filePrefix, MetadataLoader metadataLoader) {
        Phonemetadata.PhoneMetadata metadata;
        Phonemetadata.PhoneMetadata oldValue;
        String fileName = filePrefix + "_" + key;
        InputStream source = metadataLoader.loadMetadata(fileName);
        if (source == null) {
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        Phonemetadata.PhoneMetadataCollection metadataCollection = MetadataManager.loadMetadataAndCloseInput(source, 16384);
        Phonemetadata.PhoneMetadata[] metadatas = metadataCollection.metadata;
        if (metadatas.length == 0) {
            throw new IllegalStateException("empty metadata: " + fileName);
        }
        if (metadatas.length > 1) {
            logger.log(Level.WARNING, "invalid metadata (too many entries): " + fileName);
        }
        return (oldValue = map.putIfAbsent(key, metadata = metadatas[0])) != null ? oldValue : metadata;
    }
}

