/*
 * Copyright (C) 2013 The Libphonenumber Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by {@link BuildMetadataProtoFromXml}.
 * Please don't modify it directly.
 */

package com.google.i18n.phonenumbers;

import java.util.HashSet;
import java.util.Set;

public class ShortNumbersRegionCodeSet {
  // A set of all region codes for which data is available.
  static Set<String> getRegionCodeSet() {
    // The capacity is set to 66 as there are 50 different entries,
    // and this offers a load factor of roughly 0.75.
    Set<String> regionCodeSet = new HashSet<String>(66);

    regionCodeSet.add("AM");
    regionCodeSet.add("AR");
    regionCodeSet.add("BD");
    regionCodeSet.add("CH");
    regionCodeSet.add("CR");
    regionCodeSet.add("CU");
    regionCodeSet.add("CZ");
    regionCodeSet.add("DE");
    regionCodeSet.add("EE");
    regionCodeSet.add("FR");
    regionCodeSet.add("FJ");
    regionCodeSet.add("FK");
    regionCodeSet.add("FO");
    regionCodeSet.add("GB");
    regionCodeSet.add("GG");
    regionCodeSet.add("GI");
    regionCodeSet.add("GT");
    regionCodeSet.add("GY");
    regionCodeSet.add("HT");
    regionCodeSet.add("IL");
    regionCodeSet.add("IM");
    regionCodeSet.add("IT");
    regionCodeSet.add("JE");
    regionCodeSet.add("JO");
    regionCodeSet.add("KE");
    regionCodeSet.add("KI");
    regionCodeSet.add("KW");
    regionCodeSet.add("LI");
    regionCodeSet.add("LU");
    regionCodeSet.add("MD");
    regionCodeSet.add("ME");
    regionCodeSet.add("MU");
    regionCodeSet.add("MV");
    regionCodeSet.add("MZ");
    regionCodeSet.add("NA");
    regionCodeSet.add("NC");
    regionCodeSet.add("NL");
    regionCodeSet.add("NR");
    regionCodeSet.add("PA");
    regionCodeSet.add("PY");
    regionCodeSet.add("QA");
    regionCodeSet.add("RS");
    regionCodeSet.add("SA");
    regionCodeSet.add("SB");
    regionCodeSet.add("SC");
    regionCodeSet.add("SG");
    regionCodeSet.add("SH");
    regionCodeSet.add("SR");
    regionCodeSet.add("TL");
    regionCodeSet.add("UY");

    return regionCodeSet;
  }
}
