/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.CountryCodeToRegionCodeMap;
import com.google.i18n.phonenumbers.MetadataLoader;
import com.google.i18n.phonenumbers.MetadataManager;
import com.google.i18n.phonenumbers.MetadataSource;
import com.google.i18n.phonenumbers.nano.Phonemetadata;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MultiFileMetadataSourceImpl
implements MetadataSource {
    private static final Logger logger = Logger.getLogger(MultiFileMetadataSourceImpl.class.getName());
    private static final String META_DATA_FILE_PREFIX = "/com/google/i18n/phonenumbers/data/PhoneNumberMetadataProto";
    private final Map<String, Phonemetadata.PhoneMetadata> regionToMetadataMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Phonemetadata.PhoneMetadata> countryCodeToNonGeographicalMetadataMap = Collections.synchronizedMap(new HashMap());
    private final String filePrefix;
    private final MetadataLoader metadataLoader;

    public MultiFileMetadataSourceImpl(String filePrefix, MetadataLoader metadataLoader) {
        this.filePrefix = filePrefix;
        this.metadataLoader = metadataLoader;
    }

    public MultiFileMetadataSourceImpl(MetadataLoader metadataLoader) {
        this(META_DATA_FILE_PREFIX, metadataLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        Map<String, Phonemetadata.PhoneMetadata> map = this.regionToMetadataMap;
        synchronized (map) {
            if (!this.regionToMetadataMap.containsKey(regionCode)) {
                this.loadMetadataFromFile(regionCode, 0);
            }
        }
        return this.regionToMetadataMap.get(regionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Phonemetadata.PhoneMetadata getMetadataForNonGeographicalRegion(int countryCallingCode) {
        Map<Integer, Phonemetadata.PhoneMetadata> map = this.countryCodeToNonGeographicalMetadataMap;
        synchronized (map) {
            List<String> regionCodes;
            if (!this.countryCodeToNonGeographicalMetadataMap.containsKey(countryCallingCode) && (regionCodes = CountryCodeToRegionCodeMap.getCountryCodeToRegionCodeMap().get(countryCallingCode)).size() == 1 && "001".equals(regionCodes.get(0))) {
                this.loadMetadataFromFile("001", countryCallingCode);
            }
        }
        return this.countryCodeToNonGeographicalMetadataMap.get(countryCallingCode);
    }

    void loadMetadataFromFile(String regionCode, int countryCallingCode) {
        boolean isNonGeoRegion = "001".equals(regionCode);
        String fileName = this.filePrefix + "_" + (isNonGeoRegion ? String.valueOf(countryCallingCode) : regionCode);
        InputStream source = this.metadataLoader.loadMetadata(fileName);
        if (source == null) {
            logger.log(Level.SEVERE, "missing metadata: " + fileName);
            throw new IllegalStateException("missing metadata: " + fileName);
        }
        try {
            Phonemetadata.PhoneMetadataCollection metadataCollection = MultiFileMetadataSourceImpl.loadMetadataAndCloseInput(new ObjectInputStream(source));
            Phonemetadata.PhoneMetadata[] metadataList = metadataCollection.metadata;
            if (metadataList.length == 0) {
                logger.log(Level.SEVERE, "empty metadata: " + fileName);
                throw new IllegalStateException("empty metadata: " + fileName);
            }
            if (metadataList.length > 1) {
                logger.log(Level.WARNING, "invalid metadata (too many entries): " + fileName);
            }
            Phonemetadata.PhoneMetadata metadata = metadataList[0];
            if (isNonGeoRegion) {
                this.countryCodeToNonGeographicalMetadataMap.put(countryCallingCode, metadata);
            } else {
                this.regionToMetadataMap.put(regionCode, metadata);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "cannot load/parse metadata: " + fileName, e);
            throw new RuntimeException("cannot load/parse metadata: " + fileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Phonemetadata.PhoneMetadataCollection loadMetadataAndCloseInput(ObjectInputStream source) {
        int MULTI_FILE_BUFFER_SIZE = 16384;
        Phonemetadata.PhoneMetadataCollection metadataCollection = new Phonemetadata.PhoneMetadataCollection();
        try {
            metadataCollection.mergeFrom(MetadataManager.convertStreamToByteBuffer(source, 16384));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error reading input (ignored)", e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing input stream (ignored)", e);
            }
        }
        return metadataCollection;
    }
}

