/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.CopyrightNotice;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;

public final class CppMetadataGenerator {
    private final Type type;
    private final byte[] data;
    private final String guardName;
    private final String headerInclude;
    private static final char[] UPPER_HEX = "0123456789ABCDEF".toCharArray();

    public static CppMetadataGenerator create(Type type, byte[] data) {
        return new CppMetadataGenerator(type, data);
    }

    private CppMetadataGenerator(Type type, byte[] data) {
        this.type = type;
        this.data = data;
        this.guardName = CppMetadataGenerator.createGuardName(type);
        this.headerInclude = CppMetadataGenerator.createHeaderInclude(type);
    }

    public void outputHeaderFile(Writer out) throws IOException {
        PrintWriter pw = new PrintWriter(out);
        CopyrightNotice.writeTo(pw, this.type.getCopyrightYear());
        String string = String.valueOf(this.guardName);
        pw.println(string.length() != 0 ? "#ifndef ".concat(string) : new String("#ifndef "));
        String string2 = String.valueOf(this.guardName);
        pw.println(string2.length() != 0 ? "#define ".concat(string2) : new String("#define "));
        pw.println();
        CppMetadataGenerator.emitNamespaceStart(pw);
        pw.println();
        String string3 = String.valueOf((Object)this.type);
        pw.println(new StringBuilder(12 + String.valueOf(string3).length()).append("int ").append(string3).append("_size();").toString());
        string3 = String.valueOf((Object)this.type);
        pw.println(new StringBuilder(19 + String.valueOf(string3).length()).append("const void* ").append(string3).append("_get();").toString());
        pw.println();
        CppMetadataGenerator.emitNamespaceEnd(pw);
        pw.println();
        String string4 = String.valueOf(this.guardName);
        pw.println(string4.length() != 0 ? "#endif  // ".concat(string4) : new String("#endif  // "));
        pw.flush();
    }

    public void outputSourceFile(Writer out) throws IOException {
        PrintWriter pw = new PrintWriter(out);
        CopyrightNotice.writeTo(pw, this.type.getCopyrightYear());
        String string = this.headerInclude;
        pw.println(new StringBuilder(11 + String.valueOf(string).length()).append("#include \"").append(string).append("\"").toString());
        pw.println();
        CppMetadataGenerator.emitNamespaceStart(pw);
        pw.println();
        pw.println("namespace {");
        pw.println("static const unsigned char data[] = {");
        CppMetadataGenerator.emitStaticArrayData(pw, this.data);
        pw.println("};");
        pw.println("}  // namespace");
        pw.println();
        string = String.valueOf((Object)this.type);
        pw.println(new StringBuilder(13 + String.valueOf(string).length()).append("int ").append(string).append("_size() {").toString());
        pw.println("  return sizeof(data) / sizeof(data[0]);");
        pw.println("}");
        pw.println();
        string = String.valueOf((Object)this.type);
        pw.println(new StringBuilder(20 + String.valueOf(string).length()).append("const void* ").append(string).append("_get() {").toString());
        pw.println("  return data;");
        pw.println("}");
        pw.println();
        CppMetadataGenerator.emitNamespaceEnd(pw);
        pw.flush();
    }

    private static String createGuardName(Type type) {
        return String.format("I18N_PHONENUMBERS_%s_H_", type.toString().toUpperCase(Locale.ENGLISH));
    }

    private static String createHeaderInclude(Type type) {
        return String.format("phonenumbers/%s.h", new Object[]{type});
    }

    private static void emitNamespaceStart(PrintWriter pw) {
        pw.println("namespace i18n {");
        pw.println("namespace phonenumbers {");
    }

    private static void emitNamespaceEnd(PrintWriter pw) {
        pw.println("}  // namespace phonenumbers");
        pw.println("}  // namespace i18n");
    }

    static void emitStaticArrayData(PrintWriter pw, byte[] data) {
        String separator = "  ";
        for (int i = 0; i < data.length; ++i) {
            pw.print(separator);
            CppMetadataGenerator.emitHexByte(pw, data[i]);
            separator = (i + 1) % 13 == 0 ? ",\n  " : ", ";
        }
        pw.println();
    }

    private static void emitHexByte(PrintWriter pw, byte v) {
        pw.print("0x");
        pw.print(UPPER_HEX[(v & 0xF0) >>> 4]);
        pw.print(UPPER_HEX[v & 0xF]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        METADATA("metadata", 2011),
        ALTERNATE_FORMAT("alternate_format", 2012),
        SHORT_NUMBERS("short_metadata", 2013);

        private final String typeName;
        private final int copyrightYear;

        private Type(String typeName, int copyrightYear) {
            this.typeName = typeName;
            this.copyrightYear = copyrightYear;
        }

        public int getCopyrightYear() {
            return this.copyrightYear;
        }

        public String toString() {
            return this.typeName;
        }

        public static Type parse(String typeName) {
            if (METADATA.toString().equalsIgnoreCase(typeName)) {
                return METADATA;
            }
            if (ALTERNATE_FORMAT.toString().equalsIgnoreCase(typeName)) {
                return ALTERNATE_FORMAT;
            }
            if (SHORT_NUMBERS.toString().equalsIgnoreCase(typeName)) {
                return SHORT_NUMBERS;
            }
            return null;
        }
    }
}

