/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers;

import com.google.i18n.phonenumbers.Phonemetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMetadataFromXml {
    private static final Logger LOGGER = Logger.getLogger(BuildMetadataFromXml.class.getName());
    private static boolean liteBuild;
    private static final String CARRIER_CODE_FORMATTING_RULE = "carrierCodeFormattingRule";
    private static final String COUNTRY_CODE = "countryCode";
    private static final String EMERGENCY = "emergency";
    private static final String EXAMPLE_NUMBER = "exampleNumber";
    private static final String FIXED_LINE = "fixedLine";
    private static final String FORMAT = "format";
    private static final String GENERAL_DESC = "generalDesc";
    private static final String INTERNATIONAL_PREFIX = "internationalPrefix";
    private static final String INTL_FORMAT = "intlFormat";
    private static final String LEADING_DIGITS = "leadingDigits";
    private static final String LEADING_ZERO_POSSIBLE = "leadingZeroPossible";
    private static final String MAIN_COUNTRY_FOR_CODE = "mainCountryForCode";
    private static final String MOBILE = "mobile";
    private static final String NATIONAL_NUMBER_PATTERN = "nationalNumberPattern";
    private static final String NATIONAL_PREFIX = "nationalPrefix";
    private static final String NATIONAL_PREFIX_FORMATTING_RULE = "nationalPrefixFormattingRule";
    private static final String NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING = "nationalPrefixOptionalWhenFormatting";
    private static final String NATIONAL_PREFIX_FOR_PARSING = "nationalPrefixForParsing";
    private static final String NATIONAL_PREFIX_TRANSFORM_RULE = "nationalPrefixTransformRule";
    private static final String NO_INTERNATIONAL_DIALLING = "noInternationalDialling";
    private static final String NUMBER_FORMAT = "numberFormat";
    private static final String PAGER = "pager";
    private static final String PATTERN = "pattern";
    private static final String PERSONAL_NUMBER = "personalNumber";
    private static final String POSSIBLE_NUMBER_PATTERN = "possibleNumberPattern";
    private static final String PREFERRED_EXTN_PREFIX = "preferredExtnPrefix";
    private static final String PREFERRED_INTERNATIONAL_PREFIX = "preferredInternationalPrefix";
    private static final String PREMIUM_RATE = "premiumRate";
    private static final String SHARED_COST = "sharedCost";
    private static final String TOLL_FREE = "tollFree";
    private static final String UAN = "uan";
    private static final String VOICEMAIL = "voicemail";
    private static final String VOIP = "voip";

    static void setLiteBuild(boolean b) {
        liteBuild = b;
    }

    public static Phonemetadata.PhoneMetadataCollection buildPhoneMetadataCollection(String inputXmlFile, boolean liteBuild) throws Exception {
        BuildMetadataFromXml.liteBuild = liteBuild;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        File xmlFile = new File(inputXmlFile);
        Document document = builder.parse(xmlFile);
        document.getDocumentElement().normalize();
        Element rootElement = document.getDocumentElement();
        NodeList territory = rootElement.getElementsByTagName("territory");
        Phonemetadata.PhoneMetadataCollection.Builder metadataCollection = Phonemetadata.PhoneMetadataCollection.newBuilder();
        int numOfTerritories = territory.getLength();
        for (int i = 0; i < numOfTerritories; ++i) {
            Element territoryElement = (Element)territory.item(i);
            String id = territoryElement.getAttribute("id");
            try {
                Phonemetadata.PhoneMetadata metadata = BuildMetadataFromXml.loadCountryMetadata(id, territoryElement);
                metadataCollection.addMetadata(metadata);
                continue;
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Found data for region '" + id + "' but no valid region code " + "can be found to match this. Data will be ignored.");
            }
        }
        return metadataCollection.build();
    }

    public static Map<Integer, List<String>> buildCountryCodeToRegionCodeMap(Phonemetadata.PhoneMetadataCollection metadataCollection) {
        TreeMap<Integer, List<String>> countryCodeToRegionCodeMap = new TreeMap<Integer, List<String>>();
        for (Phonemetadata.PhoneMetadata metadata : metadataCollection.getMetadataList()) {
            String regionCode = metadata.getId();
            int countryCode = metadata.getCountryCode();
            if (countryCodeToRegionCodeMap.containsKey(countryCode)) {
                if (metadata.getMainCountryForCode()) {
                    ((List)countryCodeToRegionCodeMap.get(countryCode)).add(0, regionCode);
                    continue;
                }
                ((List)countryCodeToRegionCodeMap.get(countryCode)).add(regionCode);
                continue;
            }
            ArrayList<String> listWithRegionCode = new ArrayList<String>(1);
            listWithRegionCode.add(regionCode);
            countryCodeToRegionCodeMap.put(countryCode, listWithRegionCode);
        }
        return countryCodeToRegionCodeMap;
    }

    private static String validateRE(String regex) {
        return BuildMetadataFromXml.validateRE(regex, false);
    }

    static String validateRE(String regex, boolean removeWhitespace) {
        if (removeWhitespace) {
            regex = regex.replaceAll("\\s", "");
        }
        Pattern.compile(regex);
        return regex;
    }

    static String getNationalPrefix(Element element) {
        return element.hasAttribute(NATIONAL_PREFIX) ? element.getAttribute(NATIONAL_PREFIX) : "";
    }

    static Phonemetadata.PhoneMetadata.Builder loadTerritoryTagMetadata(String regionCode, Element element, String nationalPrefix, String nationalPrefixFormattingRule) {
        Phonemetadata.PhoneMetadata.Builder metadata = Phonemetadata.PhoneMetadata.newBuilder();
        metadata.setId(regionCode);
        metadata.setCountryCode(Integer.parseInt(element.getAttribute(COUNTRY_CODE)));
        if (element.hasAttribute(LEADING_DIGITS)) {
            metadata.setLeadingDigits(BuildMetadataFromXml.validateRE(element.getAttribute(LEADING_DIGITS)));
        }
        metadata.setInternationalPrefix(BuildMetadataFromXml.validateRE(element.getAttribute(INTERNATIONAL_PREFIX)));
        if (element.hasAttribute(PREFERRED_INTERNATIONAL_PREFIX)) {
            String preferredInternationalPrefix = element.getAttribute(PREFERRED_INTERNATIONAL_PREFIX);
            metadata.setPreferredInternationalPrefix(preferredInternationalPrefix);
        }
        if (element.hasAttribute(NATIONAL_PREFIX_FOR_PARSING)) {
            metadata.setNationalPrefixForParsing(BuildMetadataFromXml.validateRE(element.getAttribute(NATIONAL_PREFIX_FOR_PARSING), true));
            if (element.hasAttribute(NATIONAL_PREFIX_TRANSFORM_RULE)) {
                metadata.setNationalPrefixTransformRule(BuildMetadataFromXml.validateRE(element.getAttribute(NATIONAL_PREFIX_TRANSFORM_RULE)));
            }
        }
        if (!nationalPrefix.isEmpty()) {
            metadata.setNationalPrefix(nationalPrefix);
            if (!metadata.hasNationalPrefixForParsing()) {
                metadata.setNationalPrefixForParsing(nationalPrefix);
            }
        }
        if (element.hasAttribute(PREFERRED_EXTN_PREFIX)) {
            metadata.setPreferredExtnPrefix(element.getAttribute(PREFERRED_EXTN_PREFIX));
        }
        if (element.hasAttribute(MAIN_COUNTRY_FOR_CODE)) {
            metadata.setMainCountryForCode(true);
        }
        if (element.hasAttribute(LEADING_ZERO_POSSIBLE)) {
            metadata.setLeadingZeroPossible(true);
        }
        return metadata;
    }

    static boolean loadInternationalFormat(Phonemetadata.PhoneMetadata.Builder metadata, Element numberFormatElement, String nationalFormat) {
        Phonemetadata.NumberFormat.Builder intlFormat = Phonemetadata.NumberFormat.newBuilder();
        BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, intlFormat);
        intlFormat.setPattern(numberFormatElement.getAttribute(PATTERN));
        NodeList intlFormatPattern = numberFormatElement.getElementsByTagName(INTL_FORMAT);
        boolean hasExplicitIntlFormatDefined = false;
        if (intlFormatPattern.getLength() > 1) {
            LOGGER.log(Level.SEVERE, "A maximum of one intlFormat pattern for a numberFormat element should be defined.");
            throw new RuntimeException("Invalid number of intlFormat patterns for country: " + metadata.getId());
        }
        if (intlFormatPattern.getLength() == 0) {
            intlFormat.setFormat(nationalFormat);
        } else {
            String intlFormatPatternValue = intlFormatPattern.item(0).getFirstChild().getNodeValue();
            if (!intlFormatPatternValue.equals("NA")) {
                intlFormat.setFormat(intlFormatPatternValue);
            }
            hasExplicitIntlFormatDefined = true;
        }
        if (intlFormat.hasFormat()) {
            metadata.addIntlNumberFormat(intlFormat);
        }
        return hasExplicitIntlFormatDefined;
    }

    static String loadNationalFormat(Phonemetadata.PhoneMetadata.Builder metadata, Element numberFormatElement, Phonemetadata.NumberFormat.Builder format) {
        BuildMetadataFromXml.setLeadingDigitsPatterns(numberFormatElement, format);
        format.setPattern(BuildMetadataFromXml.validateRE(numberFormatElement.getAttribute(PATTERN)));
        NodeList formatPattern = numberFormatElement.getElementsByTagName(FORMAT);
        if (formatPattern.getLength() != 1) {
            LOGGER.log(Level.SEVERE, "Only one format pattern for a numberFormat element should be defined.");
            throw new RuntimeException("Invalid number of format patterns for country: " + metadata.getId());
        }
        String nationalFormat = formatPattern.item(0).getFirstChild().getNodeValue();
        format.setFormat(nationalFormat);
        return nationalFormat;
    }

    static void loadAvailableFormats(Phonemetadata.PhoneMetadata.Builder metadata, String regionCode, Element element, String nationalPrefix, String nationalPrefixFormattingRule, boolean nationalPrefixOptionalWhenFormatting) {
        String carrierCodeFormattingRule = "";
        if (element.hasAttribute(CARRIER_CODE_FORMATTING_RULE)) {
            carrierCodeFormattingRule = BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(element, nationalPrefix));
        }
        NodeList numberFormatElements = element.getElementsByTagName(NUMBER_FORMAT);
        boolean hasExplicitIntlFormatDefined = false;
        int numOfFormatElements = numberFormatElements.getLength();
        if (numOfFormatElements > 0) {
            for (int i = 0; i < numOfFormatElements; ++i) {
                Element numberFormatElement = (Element)numberFormatElements.item(i);
                Phonemetadata.NumberFormat.Builder format = Phonemetadata.NumberFormat.newBuilder();
                if (numberFormatElement.hasAttribute(NATIONAL_PREFIX_FORMATTING_RULE)) {
                    format.setNationalPrefixFormattingRule(BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(numberFormatElement, nationalPrefix));
                    format.setNationalPrefixOptionalWhenFormatting(numberFormatElement.hasAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING));
                } else {
                    format.setNationalPrefixFormattingRule(nationalPrefixFormattingRule);
                    format.setNationalPrefixOptionalWhenFormatting(nationalPrefixOptionalWhenFormatting);
                }
                if (numberFormatElement.hasAttribute(CARRIER_CODE_FORMATTING_RULE)) {
                    format.setDomesticCarrierCodeFormattingRule(BuildMetadataFromXml.validateRE(BuildMetadataFromXml.getDomesticCarrierCodeFormattingRuleFromElement(numberFormatElement, nationalPrefix)));
                } else {
                    format.setDomesticCarrierCodeFormattingRule(carrierCodeFormattingRule);
                }
                String nationalFormat = BuildMetadataFromXml.loadNationalFormat(metadata, numberFormatElement, format);
                metadata.addNumberFormat(format);
                if (!BuildMetadataFromXml.loadInternationalFormat(metadata, numberFormatElement, nationalFormat)) continue;
                hasExplicitIntlFormatDefined = true;
            }
            if (!hasExplicitIntlFormatDefined) {
                metadata.clearIntlNumberFormat();
            }
        }
    }

    static void setLeadingDigitsPatterns(Element numberFormatElement, Phonemetadata.NumberFormat.Builder format) {
        NodeList leadingDigitsPatternNodes = numberFormatElement.getElementsByTagName(LEADING_DIGITS);
        int numOfLeadingDigitsPatterns = leadingDigitsPatternNodes.getLength();
        if (numOfLeadingDigitsPatterns > 0) {
            for (int i = 0; i < numOfLeadingDigitsPatterns; ++i) {
                format.addLeadingDigitsPattern(BuildMetadataFromXml.validateRE(leadingDigitsPatternNodes.item(i).getFirstChild().getNodeValue(), true));
            }
        }
    }

    static String getNationalPrefixFormattingRuleFromElement(Element element, String nationalPrefix) {
        String nationalPrefixFormattingRule = element.getAttribute(NATIONAL_PREFIX_FORMATTING_RULE);
        nationalPrefixFormattingRule = nationalPrefixFormattingRule.replaceFirst("\\$NP", nationalPrefix).replaceFirst("\\$FG", "\\$1");
        return nationalPrefixFormattingRule;
    }

    static String getDomesticCarrierCodeFormattingRuleFromElement(Element element, String nationalPrefix) {
        String carrierCodeFormattingRule = element.getAttribute(CARRIER_CODE_FORMATTING_RULE);
        carrierCodeFormattingRule = carrierCodeFormattingRule.replaceFirst("\\$FG", "\\$1").replaceFirst("\\$NP", nationalPrefix);
        return carrierCodeFormattingRule;
    }

    static boolean isValidNumberType(String numberType) {
        return numberType.equals(FIXED_LINE) || numberType.equals(MOBILE) || numberType.equals(GENERAL_DESC);
    }

    static Phonemetadata.PhoneNumberDesc.Builder processPhoneNumberDescElement(Phonemetadata.PhoneNumberDesc.Builder generalDesc, Element countryElement, String numberType) {
        NodeList phoneNumberDescList = countryElement.getElementsByTagName(numberType);
        Phonemetadata.PhoneNumberDesc.Builder numberDesc = Phonemetadata.PhoneNumberDesc.newBuilder();
        if (phoneNumberDescList.getLength() == 0 && !BuildMetadataFromXml.isValidNumberType(numberType)) {
            numberDesc.setNationalNumberPattern("NA");
            numberDesc.setPossibleNumberPattern("NA");
            return numberDesc;
        }
        numberDesc.mergeFrom(generalDesc.build());
        if (phoneNumberDescList.getLength() > 0) {
            NodeList exampleNumber;
            NodeList validPattern;
            Element element = (Element)phoneNumberDescList.item(0);
            NodeList possiblePattern = element.getElementsByTagName(POSSIBLE_NUMBER_PATTERN);
            if (possiblePattern.getLength() > 0) {
                numberDesc.setPossibleNumberPattern(BuildMetadataFromXml.validateRE(possiblePattern.item(0).getFirstChild().getNodeValue(), true));
            }
            if ((validPattern = element.getElementsByTagName(NATIONAL_NUMBER_PATTERN)).getLength() > 0) {
                numberDesc.setNationalNumberPattern(BuildMetadataFromXml.validateRE(validPattern.item(0).getFirstChild().getNodeValue(), true));
            }
            if (!liteBuild && (exampleNumber = element.getElementsByTagName(EXAMPLE_NUMBER)).getLength() > 0) {
                numberDesc.setExampleNumber(exampleNumber.item(0).getFirstChild().getNodeValue());
            }
        }
        return numberDesc;
    }

    static void loadGeneralDesc(Phonemetadata.PhoneMetadata.Builder metadata, Element element) {
        Phonemetadata.PhoneNumberDesc.Builder generalDesc = Phonemetadata.PhoneNumberDesc.newBuilder();
        generalDesc = BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, GENERAL_DESC);
        metadata.setGeneralDesc(generalDesc);
        metadata.setFixedLine(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, FIXED_LINE));
        metadata.setMobile(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, MOBILE));
        metadata.setTollFree(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, TOLL_FREE));
        metadata.setPremiumRate(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PREMIUM_RATE));
        metadata.setSharedCost(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, SHARED_COST));
        metadata.setVoip(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, VOIP));
        metadata.setPersonalNumber(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PERSONAL_NUMBER));
        metadata.setPager(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, PAGER));
        metadata.setUan(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, UAN));
        metadata.setVoicemail(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, VOICEMAIL));
        metadata.setEmergency(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, EMERGENCY));
        metadata.setNoInternationalDialling(BuildMetadataFromXml.processPhoneNumberDescElement(generalDesc, element, NO_INTERNATIONAL_DIALLING));
        metadata.setSameMobileAndFixedLinePattern(metadata.getMobile().getNationalNumberPattern().equals(metadata.getFixedLine().getNationalNumberPattern()));
    }

    public static Phonemetadata.PhoneMetadata loadCountryMetadata(String regionCode, Element element) {
        String nationalPrefix = BuildMetadataFromXml.getNationalPrefix(element);
        String nationalPrefixFormattingRule = BuildMetadataFromXml.getNationalPrefixFormattingRuleFromElement(element, nationalPrefix);
        Phonemetadata.PhoneMetadata.Builder metadata = BuildMetadataFromXml.loadTerritoryTagMetadata(regionCode, element, nationalPrefix, nationalPrefixFormattingRule);
        BuildMetadataFromXml.loadAvailableFormats(metadata, regionCode, element, nationalPrefix.toString(), nationalPrefixFormattingRule.toString(), element.hasAttribute(NATIONAL_PREFIX_OPTIONAL_WHEN_FORMATTING));
        BuildMetadataFromXml.loadGeneralDesc(metadata, element);
        return metadata.build();
    }
}

